package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Set;

@Schema(name = "SecurityStationShortResponse",title = "查询驻勤点的时候返回基本信息")
@Getter
public class SecurityStationShortResponse extends ResponseAbstract {
    @Schema(name = "id", title = "驻勤点Id")
    private final String id;
    @Schema(name = "name", title = "驻勤点名称")
    private final String name;

    @Schema(name = "companyName", title = "企业名称")
    private final String companyName;

    @Schema(name = "stationTypes", title = "驻勤点类型")
    private final Set<String> stationTypes;

    @Schema(name = "scopePermissions", title = "数据范围; 包括监管归属及企业Id")
    private final Set<String> scopePermissions;

    public SecurityStationShortResponse(String id, String name, String companyName, Set<String> scopePermissions,Set<String> stationTypes) {
        this.id = id;
        this.name = name;
        this.companyName = companyName;
        this.scopePermissions = scopePermissions;
        this.stationTypes = stationTypes;
    }

    public static SecurityStationShortResponse create(String id, String name, String companyName, Set<String> scopePermissions,Set<String> stationTypes) {
        return new SecurityStationShortResponse(id, name, companyName, scopePermissions,stationTypes);
    }
}
