package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Collection;

@Schema(name = "InviteRoomUsersRpcResponse", title = "InviteRoomUsersRpcResponse 邀请人员进入房间人员信息")
@Getter
public class InviteRoomUsersWriterRpcResponse extends ResponseAbstract {
    @Schema(name = "roomId", title = "作为音视频的房间号")
    private final Long roomId;
    @Schema(name = "roomUsers", title = "被调度的人员列表")
    private final Collection<InviteRoomUsersWriterRpcResponse.InviteRoomUserResponse> roomUsers;

    public InviteRoomUsersWriterRpcResponse(Long id,
                                            Collection<InviteRoomUsersWriterRpcResponse.InviteRoomUserResponse> roomUsers) {
        this.roomId = id;
        this.roomUsers = roomUsers;
    }

    public static InviteRoomUsersWriterRpcResponse create(Long roomNo,
                                                          Collection<InviteRoomUsersWriterRpcResponse.InviteRoomUserResponse> roomUsers) {
        return new InviteRoomUsersWriterRpcResponse(roomNo, roomUsers);
    }

    @Getter
    public static class InviteRoomUserResponse extends ResponseAbstract {
        @Schema(name = "employeeId", title = "保安员的Id")
        private final String employeeId;
        @Schema(name = "employeeName", title = "保安员的姓名")
        private final String employeeName;
        @Schema(name = "organizationId", title = "企业Id")
        private final String organizationId;
        @Schema(name = "tencentUserId", title = "音视频Id")
        private final String tencentUserId;
        @Schema(name = "securityStationId", title = "驻勤点Id")
        private final String securityStationId;
        @Schema(name = "superviseDepartId", title = "监管归属Id")
        private final String superviseDepartId;

        @Schema(name = "cid", title = "最新的cid")
        private final String cid;

        @Schema(name = "points", title = "所在企业的联动值")
        private final long points;

        @Schema(name = "dispatchable", title = "该值为true的时候, 该企业的保安人员才可以被调度; 为false的时候, 该企业的保安人员不可被调度")
        private final boolean dispatchable;

        public InviteRoomUserResponse(String employeeId, String employeeName, String organizationId, String tencentUserId, String securityStationId,
                                      String cid,
                                      String superviseDepartId, long points, boolean dispatchable) {
            this.employeeId = employeeId;
            this.employeeName = employeeName;
            this.organizationId = organizationId;
            this.tencentUserId = tencentUserId;
            this.securityStationId = securityStationId;
            this.superviseDepartId = superviseDepartId;
            this.points = points;
            this.dispatchable = dispatchable;
            this.cid = cid;
        }

        public static InviteRoomUsersWriterRpcResponse.InviteRoomUserResponse create(String employeeId, String employeeName, String organizationId, String tencentUserId, String securityStationId,
                                                                                     String cid,
                                                                                     String superviseDepartId, long points, boolean dispatchable) {
            return new InviteRoomUsersWriterRpcResponse.InviteRoomUserResponse(employeeId, employeeName, organizationId, tencentUserId, securityStationId, cid, superviseDepartId
                    , points, dispatchable);
        }
    }
}
