package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;

@Getter
public class AttendanceResponse extends ResponseAbstract {

    @Schema(name = "id", title = "id")
    private final String id;

    @Schema(name = "createdTime", title = "操作时间")
    private final String createdTime;

    @Schema(name = "name", title = "姓名")
    private final String name;

    @Schema(name = "recordStatus", title = "签到状态")
    private final String recordStatus;
    @Schema(name = "referenceType", title = "操作类型")
    private final String referenceType;
    @Schema(name = "referenceName", title = "操作点位:驻勤点/点位/岗点信息")
    private final String referenceName;
    @Schema(name = "note", title = "反馈说明")
    private final String note;
    @Schema(name = "address", title = "签到地址")
    private final String address;
    @Schema(name = "attachments", title = "照片及附件信息")
    private final Collection<String> attachments;

    public AttendanceResponse(
            String id,
            String name,
            Timestamp createdTime,
            RecordStatus signInType,
            ReferenceType referenceType,
            String referenceName,
            String note, String address,
            Collection<String> attachments) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.createdTime = dateFormat.format(createdTime);
        this.id = id;
        this.name = name;
        this.recordStatus = signInType.getTypeName();
        this.referenceType = referenceType.getTypeName();
        this.referenceName = referenceName;
        this.note = note;
        this.address = address;
        this.attachments = attachments;
    }

    public static AttendanceResponse create(String id,
                                            String name,
                                            Timestamp createdTime,
                                            RecordStatus signInType,
                                            ReferenceType referenceType,
                                            String referenceName,
                                            String note, String address,
                                            Collection<String> attachments) {
        return new AttendanceResponse(
                id, name,
                createdTime, signInType, referenceType, referenceName,
                note, address, attachments);
    }
}
