package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.jdks.requests.AttendanceSearchRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Map;

@Schema(name = "AttendanceEmpReaderResponse",title = "AttendanceEmpReaderResponse 签到人员驻勤信息")
@Getter
@ColumnWidth(20)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AttendanceEmpReaderResponse extends ResponseAbstract {
    @ExcelProperty("操作时间")
    @Schema(name = "operatorTime", title = "操作时间")
    private String operatorTime;

    @ExcelProperty("操作类型")
    @Schema(name = "operatorType", title = "操作类型")
    private String operatorType;

    @ExcelProperty("姓名")
    @Schema(name = "name", title = "姓名")
    private final String name;

    @ExcelProperty("身份证号")
    @Schema(name = "idCardNo", title = "身份证号")
    private String idCardNo;

    @ColumnWidth(50)
    @ExcelProperty("公司名称")
    @Schema(name = "companyName", title = "公司名称")
    private final String companyName;

    @ColumnWidth(50)
    @ExcelProperty("驻勤点名称")
    @Schema(name = "securityStationName", title = "驻勤点名称")
    private final String securityStationName;

    @ColumnWidth(70)
    @ExcelProperty("驻勤点地址")
    @Schema(name = "securityStationAddress", title = "驻勤点地址")
    private final String securityStationAddress;

    @ColumnWidth(50)
    @ExcelProperty("项目名称")
    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    @ColumnWidth(50)
    @ExcelProperty("驻勤点监管机构")
    @Schema(name = "superviseDepartName", title = "驻勤点监管机构")
    private final String superviseDepartName;

    @ExcelProperty("备注")
    @Schema(name = "note", title = "备注")
    private String note;

    @ExcelIgnore
    @Schema(name = "operatorAddress", title = "操作地点")
    private String operatorAddress;

    @ExcelProperty("签到地址")
    @Schema(name = "address", title = "签到地址")
    private String address;

    @Schema(name = "items", title = "扩展字段: items.regionName表示所属区域; ")
    private Map<String, Object> items;

    public AttendanceEmpReaderResponse(
            AttendanceSearchRequest.SearchModel model,
            String operatorTime,
                                       RecordStatus operatorType,
                                       String operatorAddress,
                                       String name,
                                       String idCardNo,
                                       String companyName,
                                       String securityStationName,
                                       String securityStationAddress,
                                       String superviseDepartName,
                                       String note,
                                       String address,
                                       String projectName,
            Map<String, Object> items) {
        this.operatorTime = operatorTime;
        this.operatorType = operatorType.getTypeName();
        this.operatorAddress = operatorAddress;
        this.name = name;

        if (model == AttendanceSearchRequest.SearchModel.AdvanceSearch) {
            this.idCardNo = idCardNo;
            this.companyName = companyName;
            this.securityStationName = securityStationName;
            this.securityStationAddress = securityStationAddress;
            this.superviseDepartName = superviseDepartName;
            this.note = note;
            this.address = address;
            this.projectName = projectName;
            this.items = items;
        } else {

            this.idCardNo = null;
            this.companyName = null;
            this.securityStationName = null;
            this.securityStationAddress = null;
            this.superviseDepartName = null;
            this.note = null;
            this.address = null;
            this.projectName = null;
            this.items = null;
        }
    }

    public static AttendanceEmpReaderResponse create(
            AttendanceSearchRequest.SearchModel model,
            String operatorTime,
                                                     RecordStatus operatorType,
                                                     String operatorAddress,
                                                     String name,
                                                     String idCardNo,
                                                     String companyName,
                                                     String securityStationName,
                                                     String securityStationAddress,
                                                     String superviseDepartName,
                                                     String note,
                                                     String address,
                                                     String projectName,
            Map<String, Object> items) {
        return new AttendanceEmpReaderResponse(
                model,
                operatorTime,
                operatorType,
                operatorAddress,
                name,
                idCardNo,
                companyName,
                securityStationName,
                securityStationAddress,
                superviseDepartName,note,address,
                projectName,items);
    }
}
