package com.bcxin.tenant.open.jdks.requests.wrappers;

import com.bcxin.tenant.open.jdks.requests.AttendanceWriterRequest;
import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import lombok.Getter;

@Getter
public class WrappedAttendanceWriterRequest extends RequestAbstract {

    /**
     * 当前用户
     */
    private final String employeeId;

    /**
     * 签到的点
     */
    private final String referenceNumber;

    private final AttendanceWriterRequest originalRequest;


    public WrappedAttendanceWriterRequest(String employeeId,
                                          String referenceNumber,
                                          AttendanceWriterRequest originalRequest) {
        this.employeeId = employeeId;
        this.referenceNumber = referenceNumber;
        this.originalRequest = originalRequest;
    }

    public static WrappedAttendanceWriterRequest create(String employeeId, String referenceNumber, AttendanceWriterRequest originalRequest) {
        return new WrappedAttendanceWriterRequest(employeeId, referenceNumber, originalRequest);
    }
}
