package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "UpdateGeoRequest",title = "UpdateGeoRequest 当前APP坐标")
@Data
public class UpdateGeoRequest extends RequestAbstract {
    @Schema(name = "latitude", title = "纬度 y")
    private double latitude;
    @Schema(name = "longitude", title = "经度 x")
    private double longitude;
    @Schema(name = "address", title = "坐标所在地址")
    private AddressRequest address;
    @Schema(name = "directlyCheck", title = "忽略: 直接进行围栏的比对")
    private boolean directlyCheck;
    @Schema(name = "employeeIds", title = "当前用户的所有职员Ids")
    private Collection<String> employeeIds;

    @Data
    public static class AddressRequest extends RequestAbstract {
        @Schema(name = "country", title = "国家")
        private String country;
        @Schema(name = "province", title = "省份")
        private String province;
        @Schema(name = "city", title = "城市")
        private String city;
        @Schema(name = "district", title = "district")
        private String district;
        @Schema(name = "street", title = "街道地址")
        private String street;
        @Schema(name = "streetNum", title = "街道编号")
        private String streetNum;
        @Schema(name = "poiName", title = "poiName")
        private String poiName;
        @Schema(name = "cityCode", title = "城市编码")
        private String cityCode;
    }
}
