package com.bcxin.tenant.open.jdks.requests;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Timestamp;

@Schema(name = "SponsorDispatchLogSearchRequest",title = "SponsorDispatchLogSearchRequest 发起者的调度信息")
@Data
public class SponsorDispatchLogSearchRequest extends SearchRequestAbstract {
    @Schema(name = "dateFrom", title = "调度开始时间 yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Timestamp dateFrom;

    @Schema(name = "dateTo", title = "调度结束时间 yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Timestamp dateTo;
}
