package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "AppReplyRollCallEmployeeStatusRequest",title = "手机APP端收到提醒之后; 调用此API进行确认")
@Data
public class AppReplyRollCallEmployeeStatusRequest extends RequestAbstract {
    @Schema(name = "id", title = "个推的data对象中传递rollCallId的点名id")
    private Long id;
    @Schema(name = "employeeIds", title = "当前手机登入的职员Ids; 由于一个人可以入驻多企业; 因此, APP端收到的时候; 不清楚此点名是属于谁的")
    private Collection<String> employeeIds;

    public static AppReplyRollCallEmployeeStatusRequest create(Long id, Collection<String> employeeIds) {
        AppReplyRollCallEmployeeStatusRequest request = new AppReplyRollCallEmployeeStatusRequest();
        request.setEmployeeIds(employeeIds);
        request.setId(id);

        return request;
    }
}
