package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.AnalyticsLogType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Map;

@Schema(name = "AnalyticsLogCreateRequest", title = "AnalyticsLogCreateRequest 操作记录创建请求")
@Data
public class AnalyticsLogCreateRequest extends RequestAbstract{
    @Schema(name = "analyticsLogs", title = "记录集合",requiredMode = Schema.RequiredMode.REQUIRED)
    private Collection<AnalyticsLogParams> analyticsLogs;

    @Data
    public static class AnalyticsLogParams extends RequestAbstract{
        @Schema(name = "referenceNumber", title = "相关联数据的Id",
                description = "1.轨迹查询：对应职员的id（employeeid）；2.电子围栏查询：对应电子围栏的id",
                requiredMode = Schema.RequiredMode.REQUIRED)
        private String referenceNumber;

        @Schema(name = "referenceName", title = "相关联数据的名称",
                description = "1.轨迹查询：对应职员的名字；2.电子围栏查询：对应电子围栏的名字",
                requiredMode = Schema.RequiredMode.REQUIRED)
        private String referenceName;

        @Schema(name = "organizationId", title = "相关联数据所属企业的id",
                requiredMode = Schema.RequiredMode.REQUIRED)
        private String organizationId;

        @Schema(name = "type", title = "记录类型",
                description = "记录的类型。0：轨迹查询记录；1：电子围栏查询记录",
                requiredMode = Schema.RequiredMode.REQUIRED,
                example = "0")
        private AnalyticsLogType type;

        @Schema(name = "params", title = "相关的参数信息",
                description = "对于轨迹查询：需要提供查询时间段，beginDate,endDate;对于电子围栏，不需要传参数",
                example = "{\"beginDate\":\"2023-9-29 20:20:20\",\"endDate\":\"2023-10-27 11:11:11\"}")
        private Map<String, String> params;
    }
}
