package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;

@Getter
public class ToJoinRoomResponse extends ResponseAbstract {
    @Schema(name = "useId", title = "调度人的音视频的CID")
    private final String useId;

    @Schema(name = "name", title = "被调度人姓名")
    private final String name;
    @Schema(name = "yardmanType", title = "调度类型")
    private final String yardmanType;

    @Schema(name = "yardmanType", title = "调度类型")
    private final String roomNo;

    @Schema(name = "taskName", title = "任务名称")
    private final String taskName;

    @Schema(name = "comId", title = "企业Id")
    private final String comId;

    @Schema(name = "type", title = "音视频类型")
    private final String type;

    @Schema(name = "createdTime", title = "发起会议的时间")
    private final Timestamp createdTime;

    public String getIsTranscribe() {
        return "0";
    }

    public ToJoinRoomResponse(String useId,
                              String name,
                              int yardmanType,
                              Long roomId,
                              String comId,
                              CommunicatedType type,
                              Timestamp createdTime) {
        this.useId = useId;
        this.yardmanType = String.valueOf(yardmanType);
        this.roomNo = String.valueOf(roomId);
        this.taskName = "个人调度";
        this.comId = comId;
        this.name = name;
        this.type = type == CommunicatedType.Video ? "video" : "audio";
        this.createdTime = createdTime;
    }

    public static ToJoinRoomResponse create(String useId,
                                            String name,
                                            int yardmanType,
                                            Long roomId,
                                            String comId, CommunicatedType type,
                                            Timestamp createdTime) {
        ToJoinRoomResponse joinRoomResponse = new ToJoinRoomResponse(
                useId, name, yardmanType, roomId, comId, type,createdTime
        );

        return joinRoomResponse;
    }
}