package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;

@Schema(name = "ProjectRoadmapResponse",title = "项目路线图")
@Getter
public class ProjectRoadmapResponse extends ResponseAbstract {
    @Schema(name = "id", title = "id")
    private final String id;
    @Schema(name = "name", title = "路线名称")
    private final String name;
    @Schema(name = "roadmapImage", title = "路线图片")
    private final Object roadmapImage;
    @Schema(name = "projectId", title = "所属项目Id")
    private final String projectId;
    @Schema(name = "projectName", title = "所属项目名称")
    private final String projectName;
    @Schema(name = "roadmap", title = "路线相关参数")
    private final Object roadmap;
    @Schema(name = "organizationId", title = "创建者所属组织Id")
    private final String organizationId;
    @Schema(name = "organizationName", title = "创建者所属组织名称")
    private final String organizationName;
    @Schema(name = "lastUpdatedTime", title = "最后修改时间")
    private final String lastUpdatedTime;
    @Schema(name = "createdTime", title = "创建时间")
    private final Timestamp createdTime;

    public ProjectRoadmapResponse(Long id, String name, Object roadmapImage, String projectId, String projectName,
                                  Object roadmap, String organizationId, String organizationName,
                                  String lastUpdatedTime,
                                  Timestamp createdTime) {
        this.id = String.valueOf(id);
        this.name = name;
        this.roadmapImage = roadmapImage;
        this.projectId = projectId;
        this.projectName = projectName;
        this.roadmap = roadmap;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
        this.lastUpdatedTime = lastUpdatedTime;
        this.createdTime = createdTime;
    }
}
