package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeviceStatus;
import com.bcxin.tenant.open.infrastructures.enums.DeviceType;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;

@Schema(name = "DeviceResponse",title = "DeviceDetailResponse 智能终端详细信息")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DeviceResponse extends ResponseAbstract {
    private final String id;

    @Schema(name = "deviceType", title = "设备类型;此值仅在详情及框选中返回")
    private final String deviceType;

    @Schema(name = "dispatchUid", title = "IMEI号对应的uid")
    private final String dispatchUid;

    @Schema(name = "dispatchNo", title = "IMEI号; 对讲账号;此值仅在详情及框选中返回")
    private final String dispatchNo;
    @Schema(name = "deviceModel", title = "设备型号;此值仅在详情及框选中返回")
    private final String deviceModel;
    @Schema(name = "organizationId", title = "组织Id;此值仅在详情及框选中返回")
    private final String organizationId;
    @Schema(name = "organizationName", title = "组织名;此值仅在详情及框选中返回")
    private final String organizationName;
    @Schema(name = "securityStationId", title = "驻勤点Id;此值仅在详情及框选中返回")
    private final String securityStationId;
    @Schema(name = "securityStationName", title = "驻勤点名称;此值仅在详情及框选中返回")
    private final String securityStationName;

    @Schema(name = "status", title = "设备状态:Online＝在线；Offline＝离线")
    private final DeviceStatus status;

    @Schema(name = "statusText", title = "设备状态:Online＝在线；Offline＝离线")
    public String getStatusText() {
        if (this.getStatus() == null) {
            return "离线";
        }

        return this.getStatus() == DeviceStatus.Online ? "在线" : "离线";
    }

    @Schema(name = "latitude", title = "保安员所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "保安员所在x轴坐标")
    private final Double longitude;

    @Schema(name = "lastSyncTime", title = "最后同步时间")
    private final String lastSyncTime;

    private final Collection<String> permissions;

    public DeviceResponse(String id, String dispatchUid, String dispatchNo, String deviceModel, String organizationId,
                          String organizationName, String securityStationId, String securityStationName,
                          DeviceType deviceType, Double latitude, Double longitude,
                          DeviceStatus status,
                          Timestamp lastSyncTime,
                          Collection<String> permissions) {
        this.id = id;
        this.dispatchUid = dispatchUid;
        this.dispatchNo = dispatchNo;
        this.deviceModel = deviceModel;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
        this.securityStationId = securityStationId;
        this.securityStationName = securityStationName;
        if (deviceType == null) {
            this.deviceType = null;
        } else {
            this.deviceType = deviceType.getName();
        }

        this.latitude = latitude;
        this.longitude = longitude;
        this.status = status;

        if (lastSyncTime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            this.lastSyncTime = dateFormat.format(lastSyncTime);
        } else {
            this.lastSyncTime = null;
        }
        this.permissions = permissions;
    }

    public static DeviceResponse create(String id, String dispatchUid, String dispatchNo, String deviceModel,
                                        String organizationId, String organizationName, String securityStationId, String securityStationName,
                                        DeviceType deviceType, Double latitude, Double longitude,
                                        DeviceStatus status, Timestamp lastSyncTime, Collection<String> permissions) {
        return new DeviceResponse(id, dispatchUid, dispatchNo, deviceModel, organizationId, organizationName, securityStationId,
                securityStationName, deviceType, latitude, longitude,
                status, lastSyncTime, permissions);
    }

    public static DeviceResponse createForSecurityResource(String id, Double latitude, Double longitude,
                                                           DeviceStatus status) {
        return new DeviceResponse(id, null, null, null, null, null,
                null, null, null, latitude, longitude, status, null, null);
    }
}
