package com.bcxin.tenant.open.jdks.requests;

import lombok.Data;

import java.sql.Timestamp;
import java.util.Set;

@Data
public class CreateSpecialSosRequest extends RequestAbstract{
    private long id;
    private String tencentUserId;
    private String tenantEmployeeId;
    private String organizationId;
    private String securityStationId;
    private String securityStationName;
    private String superviseDepartId;
    private String superviseDepartName;

    private double latitude;
    private double longitude;
    private  String address;


    private String tenantUserName;
    private String tenantUserIdCard;
    private String stationAddress;
    private String organizationName;
    private Timestamp createdTime;
    private Set<String> resourceTypes;

    private String projectId;
    private String projectName;

    public static CreateSpecialSosRequest create(
            long id,String tencentUserId,String tenantEmployeeId,
            String organizationId,String securityStationId,String securityStationName,
            double latitude,double longitude,
            String address,String tenantUserName,String tenantUserIdCard,
            String stationAddress,String organizationName,Timestamp createdTime,
            Set<String> resourceTypes,
            String projectId,
            String projectName
            ) {
        CreateSpecialSosRequest queueRequest = new CreateSpecialSosRequest();
        queueRequest.setId(id);
        queueRequest.setTencentUserId(tencentUserId);
        queueRequest.setTenantEmployeeId(tenantEmployeeId);
        queueRequest.setOrganizationId(organizationId);
        queueRequest.setSecurityStationId(securityStationId);
        queueRequest.setSecurityStationName(securityStationName);
        queueRequest.setLatitude(latitude);
        queueRequest.setLongitude(longitude);
        queueRequest.setAddress(address);
        queueRequest.setTenantUserName(tenantUserName);
        queueRequest.setTenantUserIdCard(tenantUserIdCard);
        queueRequest.setStationAddress(stationAddress);
        queueRequest.setOrganizationName(organizationName);
        queueRequest.setCreatedTime(createdTime);
        queueRequest.setResourceTypes(resourceTypes);
        queueRequest.setProjectId(projectId);
        queueRequest.setProjectName(projectName);

        return queueRequest;
    }
}
