package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Set;

@Data
public class CreateSosPoliceIncidentQueueRequest extends RequestAbstract {
    private long id;
    private String tenantUserId;
    private String tenantEmployeeId;
    private String organizationId;
    private String securityStationId;
    private String securityStationName;
    /**
     * 推荐的监管归属
     */
    private String recommendedSuperviseDepartId;
    private String recommendedSuperviseDepartName;

    private double latitude;
    private double longitude;
    private  String address;


    private String tenantUserName;
    private String tenantUserIdCard;
    private String stationAddress;
    private String organizationName;
    private Timestamp createdTime;
    private Set<String> resourceType;

    private String projectId;
    private String projectName;

    public CreateSosPoliceIncidentQueueRequest() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static CreateSosPoliceIncidentQueueRequest create(
            IdWorker idWorker,
            TenantEmployeeContext.TenantUserModel userModel,
            CreateSosRequest request,
            String organizationName,
            String stationAddress) {
        CreateSosPoliceIncidentQueueRequest queueRequest = new CreateSosPoliceIncidentQueueRequest();
        queueRequest.setId(idWorker.getNextId());
        queueRequest.setLatitude(request.getLatitude());
        queueRequest.setLongitude(request.getLongitude());
        queueRequest.setAddress(request.getAddress());

        queueRequest.setOrganizationId(userModel.getOrganizationId());
        queueRequest.setOrganizationName(organizationName);
        queueRequest.setSecurityStationId(userModel.getSecurityStationId());
        queueRequest.setSecurityStationName(userModel.getSecurityStationName());
        queueRequest.setStationAddress(stationAddress);

        queueRequest.setRecommendedSuperviseDepartId(userModel.getSuperviseDepartId());
        queueRequest.setRecommendedSuperviseDepartName(userModel.getSuperviseDepartName());
        queueRequest.setTenantUserId(userModel.getId());
        queueRequest.setTenantEmployeeId(userModel.getEmployeeId());
        queueRequest.setTenantUserName(userModel.getName());
        queueRequest.setTenantUserIdCard(userModel.getTenantUserIdCard());
        queueRequest.setResourceType(userModel.getResourceTypesForApp());

        return queueRequest;
    }
}
