package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.TRTCActionType;
import lombok.Data;

import java.util.Collection;

@Data
public class BroadcastTrtcMessageContent extends BroadcastMessageContent<BroadcastTrtcMessageContentItem> {
    private long roomId;
    private TRTCActionType actionType;

    private Collection<String> sendToSessionSpecialIds;

    public BroadcastTrtcMessageContent(long roomId, TRTCActionType actionType, Collection<BroadcastTrtcMessageContentItem> contentItems,
                                       Collection<String> sendToSessionSpecialIds) {
        super(contentItems);
        this.roomId = roomId;
        this.actionType = actionType;
        this.sendToSessionSpecialIds = sendToSessionSpecialIds;
    }

    public static BroadcastTrtcMessageContent create(long roomId, TRTCActionType actionType, Collection<BroadcastTrtcMessageContentItem> contentItems,
                                                     Collection<String> sendToSessionSpecialIds) {
        return new BroadcastTrtcMessageContent(roomId, actionType, contentItems, sendToSessionSpecialIds);
    }
}
