package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.jdks.requests.CreateRoomWriterRpcRequest;
import com.bcxin.tenant.open.jdks.requests.InviteRoomUsersWriterRpcRequest;
import com.bcxin.tenant.open.jdks.requests.RoomReplyRequest;
import com.bcxin.tenant.open.jdks.requests.TRTCActionWriterRpcRequest;
import com.bcxin.tenant.open.jdks.responses.CreateRoomWriterRpcResponse;
import com.bcxin.tenant.open.jdks.responses.InviteRoomUsersWriterRpcResponse;
import com.bcxin.tenant.open.jdks.responses.RoomResponse;
import com.bcxin.tenant.open.jdks.responses.ToJoinRoomResponse;

import java.util.Collection;

public interface RoomRpcProvider {
    CreateRoomWriterRpcResponse create(CreateRoomWriterRpcRequest request);

    InviteRoomUsersWriterRpcResponse inviteUsers(long roomId, InviteRoomUsersWriterRpcRequest request);

    RoomResponse get(Long id);

    void close(Long id);

    Collection<Long> getReadyForCalculatedRoomIds(int pageSize);

    void removeUser(long roomId, String tencentUserId);

    Collection<String> getTrtcSendToSessionSpecialIds(long roomId, TRTCActionWriterRpcRequest request);

    void dispatch(RoomReplyRequest request);
}