package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.requests.*;
import com.bcxin.tenant.open.jdks.requests.CreatePoliceIncidentsRequest;
import com.bcxin.tenant.open.jdks.requests.CreateSosRequest;
import com.bcxin.tenant.open.jdks.requests.PoliceIncidentsSearchRequest;
import com.bcxin.tenant.open.jdks.requests.UpdatePoliceIncidentsRequest;
import com.bcxin.tenant.open.jdks.responses.PoliceIncidentOverviewResponse;
import com.bcxin.tenant.open.jdks.responses.PoliceIncidentRegionReportResponse;
import com.bcxin.tenant.open.jdks.responses.PoliceIncidentsLevelCountResponse;

import java.util.Collection;

/**
 * 对提交警情信息
 */
public interface PoliceIncidentsRpcProvider {
    /**
     * 新增警情上报
     *
     * @param request
     */
    void create(CreatePoliceIncidentsRequest request);

    void update(UpdatePoliceIncidentsRequest request);

    void updateInfo(UpdatePoliceIncidentsInfoRequest request);

    void updateStatus(Long id);

    void create(CreateSosRequest request);

    void create(Collection<CreateSpecialSosRequest> specialSosRequests);

    void update(UpdateSosPoliceIncidentStatusRequest request);

    PoliceIncidentOverviewResponse get(Long id);

    PoliceIncidentOverviewResponse layerGet(Long id);

    EntityCollection<PoliceIncidentOverviewResponse> search(PoliceIncidentsSearchRequest request);


    EntityCollection<PoliceIncidentOverviewResponse> getPendingByLevel(PoliceIncidentGetPendingRequest request);


    PoliceIncidentsLevelCountResponse getPendingTotal(PoliceIncidentStatisticsRequest request);

    void delete(Long id);

    Collection<PoliceIncidentRegionReportResponse> getReport(PoliceIncidentRegionReportRequest request);
}
