package com.bcxin.tenant.open.infrastructures.utils;

import com.bcxin.tenant.open.infrastructures.exceptions.RetryableTenantException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtil.class);

    public static void execute(Runnable runnable, int retries) {
        for (int i = 0; i < retries; i++) {
            try {
                runnable.run();
                break;
            } catch (RetryableTenantException ex) {
                logger.error("重试执行发生异常", ex);
            }
        }
    }
}
