package com.bcxin.tenant.open.infrastructures.utils;

import java.sql.Timestamp;
import java.time.*;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static Date getToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        return calendar.getTime();
    }

    public static Timestamp getTodayEndTimestamp() {
        return getSpecialDayEndTimestamp(Timestamp.from(Instant.now()));
    }

    public static Timestamp getSpecialDayEndTimestamp(Date timestamp)
    {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 999);

        return Timestamp.from(calendar.toInstant());
    }

    public static LocalDateTime getNowLocalDateTime() {
        Calendar calendar = Calendar.getInstance();
        LocalDateTime now = LocalDateTime.of(
                calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH) + 1,
                calendar.get(Calendar.DAY_OF_MONTH), calendar.get(Calendar.HOUR), calendar.get(Calendar.MINUTE),
                calendar.get(Calendar.SECOND));
        LocalDateTime localDateTime =
                LocalDateTime.ofInstant(Instant.ofEpochSecond(Instant.now().getEpochSecond()), ZoneId.systemDefault());

        return localDateTime;
    }
}
