package com.bcxin.tenant.open.infrastructures.exceptions;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter(AccessLevel.PROTECTED)
public class NoFoundTenantException extends TenantExceptionAbstract {
    private Object data;
    public NoFoundTenantException() {
        super("404. 找不到数据!");
    }

    public NoFoundTenantException(String msg) {
        super(msg);
    }

    public NoFoundTenantException(String msg, Object data) {
        this(msg);
        this.setData(data);
    }
}
