package com.bcxin.tenant.open.infrastructures.enums;

import lombok.Getter;

import java.util.Collection;
import java.util.HashSet;

@Getter
public enum RepetitiveRule {
    Monday(1 << 0, "周一"),
    Tuesday(1 << 1, "周二"),
    Wednesday(1 << 2, "周三"),
    Thursday(1 << 3, "周四"),
    Friday(1 << 4, "周五"),
    Saturday(1 << 5, "周六"),
    Sunday(1 << 6, "周天");
    String name;
    int value;

    private RepetitiveRule(int value, String name) {
        this.name = name;
        this.value = value;
    }

    public static int calculateRepetitiveRule(Collection<RepetitiveRule> rules) {
        int result = 0;
        for (RepetitiveRule rule : rules) {
            result = result | rule.value;
        }

        return result;
    }

    public static Collection<RepetitiveRule> getSelectedRepetitiveRules(int repetitiveRule) {
        Collection<RepetitiveRule> result = new HashSet<>();
        for (RepetitiveRule rule : RepetitiveRule.values()) {
            if ((rule.value & repetitiveRule) > 0) {
                result.add(rule);
            }
        }

        return result;
    }
}
