/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.utils;

import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.jdks.requests.enums.EmployeeResourceType;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class RequestUtil {
    public static Collection<ResourceType> getResourceTypes(Collection<EmployeeResourceType> employeeResourceTypes) {
        if (CollectionUtils.isEmpty(employeeResourceTypes)) {
            return Collections.EMPTY_LIST;
        }
        return employeeResourceTypes.stream().map(ii -> {
            switch (ii) {
                case Security: {
                    return ResourceType.Security;
                }
                case Population: {
                    return ResourceType.Population;
                }
                case Proprietor: {
                    return ResourceType.Proprietor;
                }
                case ProprietorManaged: {
                    return ResourceType.ProprietorManaged;
                }
                case ProfessionalPopulation: {
                    return ResourceType.Population;
                }
            }
            return null;
        }).filter(ii -> ii != null).collect(Collectors.toList());
    }

    public static Collection<ResourceType> getExcludedResourceTypes(Collection<EmployeeResourceType> employeeResourceTypes) {
        if (CollectionUtils.isEmpty(employeeResourceTypes)) {
            return Collections.EMPTY_LIST;
        }
        return employeeResourceTypes.stream().map(ii -> ii == EmployeeResourceType.ProfessionalPopulation ? ResourceType.Security : null).filter(ii -> ii != null).collect(Collectors.toList());
    }
}

