/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.util.CollectionUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdSyncStatusDocument
extends EntityAbstract {
    @Indexed
    private DispatchDataType dataType;
    @Indexed
    @Id
    private String topic;
    private long ts;
    private long totalSyncCount;
    private Timestamp lastSyncTime;
    private long lastOffset;
    private String lastIds;

    public RdSyncStatusDocument() {
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void assignLastIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.lastIds = ids.stream().limit(20L).collect(Collectors.joining(";"));
        this.setTotalSyncCount(this.getTotalSyncCount() + (long)ids.size());
    }

    public DispatchDataType getDataType() {
        return this.dataType;
    }

    public String getTopic() {
        return this.topic;
    }

    public long getTs() {
        return this.ts;
    }

    public long getTotalSyncCount() {
        return this.totalSyncCount;
    }

    public Timestamp getLastSyncTime() {
        return this.lastSyncTime;
    }

    public long getLastOffset() {
        return this.lastOffset;
    }

    public String getLastIds() {
        return this.lastIds;
    }

    public void setDataType(DispatchDataType dataType) {
        this.dataType = dataType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setTotalSyncCount(long totalSyncCount) {
        this.totalSyncCount = totalSyncCount;
    }

    public void setLastSyncTime(Timestamp lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    public void setLastOffset(long lastOffset) {
        this.lastOffset = lastOffset;
    }

    public void setLastIds(String lastIds) {
        this.lastIds = lastIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdSyncStatusDocument)) {
            return false;
        }
        RdSyncStatusDocument other = (RdSyncStatusDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        if (this.getTotalSyncCount() != other.getTotalSyncCount()) {
            return false;
        }
        if (this.getLastOffset() != other.getLastOffset()) {
            return false;
        }
        DispatchDataType this$dataType = this.getDataType();
        DispatchDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        Timestamp this$lastSyncTime = this.getLastSyncTime();
        Timestamp other$lastSyncTime = other.getLastSyncTime();
        if (this$lastSyncTime == null ? other$lastSyncTime != null : !((Object)this$lastSyncTime).equals(other$lastSyncTime)) {
            return false;
        }
        String this$lastIds = this.getLastIds();
        String other$lastIds = other.getLastIds();
        return !(this$lastIds == null ? other$lastIds != null : !this$lastIds.equals(other$lastIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdSyncStatusDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        long $totalSyncCount = this.getTotalSyncCount();
        result = result * 59 + (int)($totalSyncCount >>> 32 ^ $totalSyncCount);
        long $lastOffset = this.getLastOffset();
        result = result * 59 + (int)($lastOffset >>> 32 ^ $lastOffset);
        DispatchDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        Timestamp $lastSyncTime = this.getLastSyncTime();
        result = result * 59 + ($lastSyncTime == null ? 43 : ((Object)$lastSyncTime).hashCode());
        String $lastIds = this.getLastIds();
        result = result * 59 + ($lastIds == null ? 43 : $lastIds.hashCode());
        return result;
    }

    public String toString() {
        return "RdSyncStatusDocument(dataType=" + this.getDataType() + ", topic=" + this.getTopic() + ", ts=" + this.getTs() + ", totalSyncCount=" + this.getTotalSyncCount() + ", lastSyncTime=" + this.getLastSyncTime() + ", lastOffset=" + this.getLastOffset() + ", lastIds=" + this.getLastIds() + ")";
    }
}

