/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.StringUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdSecurityStationDocument
extends EntityAbstract {
    @Id
    @Indexed
    private String id;
    @Indexed(weight=22.0)
    private String name;
    @Searchable(sortable=false, nostem=true, weight=20.0)
    private String keyword;
    @Indexed
    @TagIndexed
    private Set<String> stationTypes;
    @Indexed
    private String organizationId;
    @Indexed
    private String companyName;
    private String principalId;
    private String principalName;
    private String principalContact;
    private String serviceScope;
    private String address;
    @Indexed
    @TagIndexed
    private Set<String> followedDeviceNos;
    @Indexed(sortable=true)
    private Integer countOfSecurityMan;
    private Integer countOfCommunityUser;
    @Indexed
    @GeoIndexed
    private Point lonLat;
    @Indexed
    private String superviseDepartId;
    private String superviseDepartName;
    private String siteState;
    @Indexed
    private boolean isActivated;
    private Timestamp beginDate;
    private Timestamp endDate;
    @Indexed
    private Set<String> resourceTypes;
    private String industry;
    private String institutional;
    @Indexed
    private Set<String> scopePermissions;
    private String proprietorCompanyName;
    private String proprietorCompanyId;
    private Timestamp lastUpdatedTime;
    private String projectId;
    private String projectName;
    private Double performRange;
    private Boolean hasVideo;

    public void updateWord(String ... text) {
        if (text == null || text.length == 0) {
            this.setKeyword("");
        }
        String content = Arrays.stream(text).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.joining(" "));
        this.setKeyword(content);
    }

    public void assignProprietor(String companyId, String companyName) {
        this.setProprietorCompanyId(companyId);
        this.setProprietorCompanyName(companyName);
    }

    public void changeState(Date beginDate, Date endDate, String siteState) {
        if (beginDate != null) {
            this.setBeginDate(Timestamp.from(Instant.ofEpochMilli(beginDate.getTime())));
        } else {
            this.setBeginDate(null);
        }
        if (endDate != null) {
            this.setEndDate(Timestamp.from(Instant.ofEpochMilli(endDate.getTime())));
        } else {
            this.setEndDate(null);
        }
        this.setSiteState(siteState);
        this.setActivated(false);
        if (this.getBeginDate() != null && this.getEndDate() != null && this.getSiteState() == "\u5df2\u5b8c\u5584") {
            Timestamp now = Timestamp.from(Instant.now());
            if (this.getBeginDate().before(now) && this.getEndDate().after(now)) {
                this.setActivated(true);
            }
        }
    }

    public boolean addFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.merge(this.getFollowedDeviceNos(), (Object[])new String[]{deviceNo}));
        return true;
    }

    public boolean removeFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.remove(this.getFollowedDeviceNos(), (Object[])new String[]{deviceNo}));
        return true;
    }

    public void updateCountOfCommunityUser(int countOfCommunityUser) {
        this.setCountOfCommunityUser(countOfCommunityUser);
    }

    public void addResourceTypes(String ... resourceTypes) {
        this.setResourceTypes(SetUtil.merge(this.getResourceTypes(), (Object[])resourceTypes));
    }

    public void addScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])scopeIds));
    }

    public void removeBusinessScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.remove(this.getScopePermissions(), (Object[])scopeIds));
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])new String[]{this.getOrganizationId(), this.getSuperviseDepartId()}));
    }

    public void rest() {
        this.setSuperviseDepartId("#1");
        this.setScopePermissions(new HashSet<String>());
        this.setResourceTypes(new HashSet<String>());
        this.setProprietorCompanyName(null);
        this.setProprietorCompanyId(null);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Set<String> getStationTypes() {
        return this.stationTypes;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getPrincipalContact() {
        return this.principalContact;
    }

    public String getServiceScope() {
        return this.serviceScope;
    }

    public String getAddress() {
        return this.address;
    }

    public Set<String> getFollowedDeviceNos() {
        return this.followedDeviceNos;
    }

    public Integer getCountOfSecurityMan() {
        return this.countOfSecurityMan;
    }

    public Integer getCountOfCommunityUser() {
        return this.countOfCommunityUser;
    }

    public Point getLonLat() {
        return this.lonLat;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getSiteState() {
        return this.siteState;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public Timestamp getBeginDate() {
        return this.beginDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public String getIndustry() {
        return this.industry;
    }

    public String getInstitutional() {
        return this.institutional;
    }

    public Set<String> getScopePermissions() {
        return this.scopePermissions;
    }

    public String getProprietorCompanyName() {
        return this.proprietorCompanyName;
    }

    public String getProprietorCompanyId() {
        return this.proprietorCompanyId;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Double getPerformRange() {
        return this.performRange;
    }

    public Boolean getHasVideo() {
        return this.hasVideo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setStationTypes(Set<String> stationTypes) {
        this.stationTypes = stationTypes;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public void setPrincipalContact(String principalContact) {
        this.principalContact = principalContact;
    }

    public void setServiceScope(String serviceScope) {
        this.serviceScope = serviceScope;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setFollowedDeviceNos(Set<String> followedDeviceNos) {
        this.followedDeviceNos = followedDeviceNos;
    }

    public void setCountOfSecurityMan(Integer countOfSecurityMan) {
        this.countOfSecurityMan = countOfSecurityMan;
    }

    public void setCountOfCommunityUser(Integer countOfCommunityUser) {
        this.countOfCommunityUser = countOfCommunityUser;
    }

    public void setLonLat(Point lonLat) {
        this.lonLat = lonLat;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    public void setSiteState(String siteState) {
        this.siteState = siteState;
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public void setBeginDate(Timestamp beginDate) {
        this.beginDate = beginDate;
    }

    public void setEndDate(Timestamp endDate) {
        this.endDate = endDate;
    }

    public void setResourceTypes(Set<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public void setInstitutional(String institutional) {
        this.institutional = institutional;
    }

    public void setScopePermissions(Set<String> scopePermissions) {
        this.scopePermissions = scopePermissions;
    }

    public void setProprietorCompanyName(String proprietorCompanyName) {
        this.proprietorCompanyName = proprietorCompanyName;
    }

    public void setProprietorCompanyId(String proprietorCompanyId) {
        this.proprietorCompanyId = proprietorCompanyId;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setPerformRange(Double performRange) {
        this.performRange = performRange;
    }

    public void setHasVideo(Boolean hasVideo) {
        this.hasVideo = hasVideo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdSecurityStationDocument)) {
            return false;
        }
        RdSecurityStationDocument other = (RdSecurityStationDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isActivated() != other.isActivated()) {
            return false;
        }
        Integer this$countOfSecurityMan = this.getCountOfSecurityMan();
        Integer other$countOfSecurityMan = other.getCountOfSecurityMan();
        if (this$countOfSecurityMan == null ? other$countOfSecurityMan != null : !((Object)this$countOfSecurityMan).equals(other$countOfSecurityMan)) {
            return false;
        }
        Integer this$countOfCommunityUser = this.getCountOfCommunityUser();
        Integer other$countOfCommunityUser = other.getCountOfCommunityUser();
        if (this$countOfCommunityUser == null ? other$countOfCommunityUser != null : !((Object)this$countOfCommunityUser).equals(other$countOfCommunityUser)) {
            return false;
        }
        Double this$performRange = this.getPerformRange();
        Double other$performRange = other.getPerformRange();
        if (this$performRange == null ? other$performRange != null : !((Object)this$performRange).equals(other$performRange)) {
            return false;
        }
        Boolean this$hasVideo = this.getHasVideo();
        Boolean other$hasVideo = other.getHasVideo();
        if (this$hasVideo == null ? other$hasVideo != null : !((Object)this$hasVideo).equals(other$hasVideo)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        Set<String> this$stationTypes = this.getStationTypes();
        Set<String> other$stationTypes = other.getStationTypes();
        if (this$stationTypes == null ? other$stationTypes != null : !((Object)this$stationTypes).equals(other$stationTypes)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        if (this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName)) {
            return false;
        }
        String this$principalId = this.getPrincipalId();
        String other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        String this$principalName = this.getPrincipalName();
        String other$principalName = other.getPrincipalName();
        if (this$principalName == null ? other$principalName != null : !this$principalName.equals(other$principalName)) {
            return false;
        }
        String this$principalContact = this.getPrincipalContact();
        String other$principalContact = other.getPrincipalContact();
        if (this$principalContact == null ? other$principalContact != null : !this$principalContact.equals(other$principalContact)) {
            return false;
        }
        String this$serviceScope = this.getServiceScope();
        String other$serviceScope = other.getServiceScope();
        if (this$serviceScope == null ? other$serviceScope != null : !this$serviceScope.equals(other$serviceScope)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Set<String> this$followedDeviceNos = this.getFollowedDeviceNos();
        Set<String> other$followedDeviceNos = other.getFollowedDeviceNos();
        if (this$followedDeviceNos == null ? other$followedDeviceNos != null : !((Object)this$followedDeviceNos).equals(other$followedDeviceNos)) {
            return false;
        }
        Point this$lonLat = this.getLonLat();
        Point other$lonLat = other.getLonLat();
        if (this$lonLat == null ? other$lonLat != null : !this$lonLat.equals(other$lonLat)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$superviseDepartName = this.getSuperviseDepartName();
        String other$superviseDepartName = other.getSuperviseDepartName();
        if (this$superviseDepartName == null ? other$superviseDepartName != null : !this$superviseDepartName.equals(other$superviseDepartName)) {
            return false;
        }
        String this$siteState = this.getSiteState();
        String other$siteState = other.getSiteState();
        if (this$siteState == null ? other$siteState != null : !this$siteState.equals(other$siteState)) {
            return false;
        }
        Timestamp this$beginDate = this.getBeginDate();
        Timestamp other$beginDate = other.getBeginDate();
        if (this$beginDate == null ? other$beginDate != null : !((Object)this$beginDate).equals(other$beginDate)) {
            return false;
        }
        Timestamp this$endDate = this.getEndDate();
        Timestamp other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Set<String> this$resourceTypes = this.getResourceTypes();
        Set<String> other$resourceTypes = other.getResourceTypes();
        if (this$resourceTypes == null ? other$resourceTypes != null : !((Object)this$resourceTypes).equals(other$resourceTypes)) {
            return false;
        }
        String this$industry = this.getIndustry();
        String other$industry = other.getIndustry();
        if (this$industry == null ? other$industry != null : !this$industry.equals(other$industry)) {
            return false;
        }
        String this$institutional = this.getInstitutional();
        String other$institutional = other.getInstitutional();
        if (this$institutional == null ? other$institutional != null : !this$institutional.equals(other$institutional)) {
            return false;
        }
        Set<String> this$scopePermissions = this.getScopePermissions();
        Set<String> other$scopePermissions = other.getScopePermissions();
        if (this$scopePermissions == null ? other$scopePermissions != null : !((Object)this$scopePermissions).equals(other$scopePermissions)) {
            return false;
        }
        String this$proprietorCompanyName = this.getProprietorCompanyName();
        String other$proprietorCompanyName = other.getProprietorCompanyName();
        if (this$proprietorCompanyName == null ? other$proprietorCompanyName != null : !this$proprietorCompanyName.equals(other$proprietorCompanyName)) {
            return false;
        }
        String this$proprietorCompanyId = this.getProprietorCompanyId();
        String other$proprietorCompanyId = other.getProprietorCompanyId();
        if (this$proprietorCompanyId == null ? other$proprietorCompanyId != null : !this$proprietorCompanyId.equals(other$proprietorCompanyId)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        return !(this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdSecurityStationDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActivated() ? 79 : 97);
        Integer $countOfSecurityMan = this.getCountOfSecurityMan();
        result = result * 59 + ($countOfSecurityMan == null ? 43 : ((Object)$countOfSecurityMan).hashCode());
        Integer $countOfCommunityUser = this.getCountOfCommunityUser();
        result = result * 59 + ($countOfCommunityUser == null ? 43 : ((Object)$countOfCommunityUser).hashCode());
        Double $performRange = this.getPerformRange();
        result = result * 59 + ($performRange == null ? 43 : ((Object)$performRange).hashCode());
        Boolean $hasVideo = this.getHasVideo();
        result = result * 59 + ($hasVideo == null ? 43 : ((Object)$hasVideo).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        Set<String> $stationTypes = this.getStationTypes();
        result = result * 59 + ($stationTypes == null ? 43 : ((Object)$stationTypes).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        String $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        String $principalName = this.getPrincipalName();
        result = result * 59 + ($principalName == null ? 43 : $principalName.hashCode());
        String $principalContact = this.getPrincipalContact();
        result = result * 59 + ($principalContact == null ? 43 : $principalContact.hashCode());
        String $serviceScope = this.getServiceScope();
        result = result * 59 + ($serviceScope == null ? 43 : $serviceScope.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Set<String> $followedDeviceNos = this.getFollowedDeviceNos();
        result = result * 59 + ($followedDeviceNos == null ? 43 : ((Object)$followedDeviceNos).hashCode());
        Point $lonLat = this.getLonLat();
        result = result * 59 + ($lonLat == null ? 43 : $lonLat.hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $superviseDepartName = this.getSuperviseDepartName();
        result = result * 59 + ($superviseDepartName == null ? 43 : $superviseDepartName.hashCode());
        String $siteState = this.getSiteState();
        result = result * 59 + ($siteState == null ? 43 : $siteState.hashCode());
        Timestamp $beginDate = this.getBeginDate();
        result = result * 59 + ($beginDate == null ? 43 : ((Object)$beginDate).hashCode());
        Timestamp $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Set<String> $resourceTypes = this.getResourceTypes();
        result = result * 59 + ($resourceTypes == null ? 43 : ((Object)$resourceTypes).hashCode());
        String $industry = this.getIndustry();
        result = result * 59 + ($industry == null ? 43 : $industry.hashCode());
        String $institutional = this.getInstitutional();
        result = result * 59 + ($institutional == null ? 43 : $institutional.hashCode());
        Set<String> $scopePermissions = this.getScopePermissions();
        result = result * 59 + ($scopePermissions == null ? 43 : ((Object)$scopePermissions).hashCode());
        String $proprietorCompanyName = this.getProprietorCompanyName();
        result = result * 59 + ($proprietorCompanyName == null ? 43 : $proprietorCompanyName.hashCode());
        String $proprietorCompanyId = this.getProprietorCompanyId();
        result = result * 59 + ($proprietorCompanyId == null ? 43 : $proprietorCompanyId.hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        return result;
    }

    public String toString() {
        return "RdSecurityStationDocument(id=" + this.getId() + ", name=" + this.getName() + ", keyword=" + this.getKeyword() + ", stationTypes=" + this.getStationTypes() + ", organizationId=" + this.getOrganizationId() + ", companyName=" + this.getCompanyName() + ", principalId=" + this.getPrincipalId() + ", principalName=" + this.getPrincipalName() + ", principalContact=" + this.getPrincipalContact() + ", serviceScope=" + this.getServiceScope() + ", address=" + this.getAddress() + ", followedDeviceNos=" + this.getFollowedDeviceNos() + ", countOfSecurityMan=" + this.getCountOfSecurityMan() + ", countOfCommunityUser=" + this.getCountOfCommunityUser() + ", lonLat=" + this.getLonLat() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", superviseDepartName=" + this.getSuperviseDepartName() + ", siteState=" + this.getSiteState() + ", isActivated=" + this.isActivated() + ", beginDate=" + this.getBeginDate() + ", endDate=" + this.getEndDate() + ", resourceTypes=" + this.getResourceTypes() + ", industry=" + this.getIndustry() + ", institutional=" + this.getInstitutional() + ", scopePermissions=" + this.getScopePermissions() + ", proprietorCompanyName=" + this.getProprietorCompanyName() + ", proprietorCompanyId=" + this.getProprietorCompanyId() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", performRange=" + this.getPerformRange() + ", hasVideo=" + this.getHasVideo() + ")";
    }
}

