/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeviceStatus;
import com.bcxin.tenant.open.infrastructures.enums.DeviceType;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.StringUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdDeviceDocument
extends EntityAbstract
implements Aggregate {
    @Id
    @Indexed
    private String id;
    @Searchable(sortable=false, nostem=true, weight=20.0)
    private String keyword;
    @Indexed
    private String dispatchNo;
    private String deviceUid;
    private String deviceNo;
    private String deviceModel;
    @Indexed
    private String organizationId;
    private String organizationName;
    @Indexed
    private String securityStationId;
    private String securityStationName;
    private DeviceType deviceType;
    private DeviceStatus deviceStatus;
    @Indexed
    private Boolean dispatchable;
    private String proprietorCompanyName;
    private String proprietorCompanyId;
    @Indexed
    @GeoIndexed
    private Point lonLat;
    @Indexed
    private Set<String> resourceTypes;
    private Timestamp lastSyncTime;
    @Indexed
    private Set<String> scopePermissions;

    public void assignProprietor(String companyId, String companyName) {
        this.setProprietorCompanyId(companyId);
        this.setProprietorCompanyName(companyName);
    }

    public void changeStatus(DeviceStatus deviceStatus) {
        this.setDeviceStatus(deviceStatus);
        this.setDispatchable(deviceStatus == DeviceStatus.Online);
    }

    public static RdDeviceDocument create(String id) {
        RdDeviceDocument document = new RdDeviceDocument();
        document.setId(id);
        document.setLonLat(new Point(BusinessConstants.INVALID_LON_LAT.doubleValue(), BusinessConstants.INVALID_LON_LAT.doubleValue()));
        return document;
    }

    public void updateWord(String ... text) {
        if (text == null || text.length == 0) {
            this.setKeyword("");
        }
        String content = Arrays.stream(text).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.joining(" "));
        this.setKeyword(content);
    }

    public void addResourceTypes(String ... resourceTypes) {
        this.setResourceTypes(SetUtil.merge(this.getResourceTypes(), (Object[])resourceTypes));
    }

    public void addScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])scopeIds));
    }

    public void removeBusinessScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.remove(this.getScopePermissions(), (Object[])scopeIds));
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])new String[]{this.getOrganizationId()}));
    }

    public void changeLonLat(Point lonLat) {
        this.setLonLat(lonLat);
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void rest() {
        this.setScopePermissions(new HashSet<String>());
        this.setResourceTypes(new HashSet<String>());
    }

    public String getId() {
        return this.id;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getDispatchNo() {
        return this.dispatchNo;
    }

    public String getDeviceUid() {
        return this.deviceUid;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public DeviceStatus getDeviceStatus() {
        return this.deviceStatus;
    }

    public Boolean getDispatchable() {
        return this.dispatchable;
    }

    public String getProprietorCompanyName() {
        return this.proprietorCompanyName;
    }

    public String getProprietorCompanyId() {
        return this.proprietorCompanyId;
    }

    public Point getLonLat() {
        return this.lonLat;
    }

    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public Timestamp getLastSyncTime() {
        return this.lastSyncTime;
    }

    public Set<String> getScopePermissions() {
        return this.scopePermissions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setDispatchNo(String dispatchNo) {
        this.dispatchNo = dispatchNo;
    }

    public void setDeviceUid(String deviceUid) {
        this.deviceUid = deviceUid;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setSecurityStationId(String securityStationId) {
        this.securityStationId = securityStationId;
    }

    public void setSecurityStationName(String securityStationName) {
        this.securityStationName = securityStationName;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceStatus(DeviceStatus deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public void setDispatchable(Boolean dispatchable) {
        this.dispatchable = dispatchable;
    }

    public void setProprietorCompanyName(String proprietorCompanyName) {
        this.proprietorCompanyName = proprietorCompanyName;
    }

    public void setProprietorCompanyId(String proprietorCompanyId) {
        this.proprietorCompanyId = proprietorCompanyId;
    }

    public void setLonLat(Point lonLat) {
        this.lonLat = lonLat;
    }

    public void setResourceTypes(Set<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public void setLastSyncTime(Timestamp lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    public void setScopePermissions(Set<String> scopePermissions) {
        this.scopePermissions = scopePermissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdDeviceDocument)) {
            return false;
        }
        RdDeviceDocument other = (RdDeviceDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$dispatchable = this.getDispatchable();
        Boolean other$dispatchable = other.getDispatchable();
        if (this$dispatchable == null ? other$dispatchable != null : !((Object)this$dispatchable).equals(other$dispatchable)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$dispatchNo = this.getDispatchNo();
        String other$dispatchNo = other.getDispatchNo();
        if (this$dispatchNo == null ? other$dispatchNo != null : !this$dispatchNo.equals(other$dispatchNo)) {
            return false;
        }
        String this$deviceUid = this.getDeviceUid();
        String other$deviceUid = other.getDeviceUid();
        if (this$deviceUid == null ? other$deviceUid != null : !this$deviceUid.equals(other$deviceUid)) {
            return false;
        }
        String this$deviceNo = this.getDeviceNo();
        String other$deviceNo = other.getDeviceNo();
        if (this$deviceNo == null ? other$deviceNo != null : !this$deviceNo.equals(other$deviceNo)) {
            return false;
        }
        String this$deviceModel = this.getDeviceModel();
        String other$deviceModel = other.getDeviceModel();
        if (this$deviceModel == null ? other$deviceModel != null : !this$deviceModel.equals(other$deviceModel)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$organizationName = this.getOrganizationName();
        String other$organizationName = other.getOrganizationName();
        if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
            return false;
        }
        String this$securityStationId = this.getSecurityStationId();
        String other$securityStationId = other.getSecurityStationId();
        if (this$securityStationId == null ? other$securityStationId != null : !this$securityStationId.equals(other$securityStationId)) {
            return false;
        }
        String this$securityStationName = this.getSecurityStationName();
        String other$securityStationName = other.getSecurityStationName();
        if (this$securityStationName == null ? other$securityStationName != null : !this$securityStationName.equals(other$securityStationName)) {
            return false;
        }
        DeviceType this$deviceType = this.getDeviceType();
        DeviceType other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        DeviceStatus this$deviceStatus = this.getDeviceStatus();
        DeviceStatus other$deviceStatus = other.getDeviceStatus();
        if (this$deviceStatus == null ? other$deviceStatus != null : !this$deviceStatus.equals(other$deviceStatus)) {
            return false;
        }
        String this$proprietorCompanyName = this.getProprietorCompanyName();
        String other$proprietorCompanyName = other.getProprietorCompanyName();
        if (this$proprietorCompanyName == null ? other$proprietorCompanyName != null : !this$proprietorCompanyName.equals(other$proprietorCompanyName)) {
            return false;
        }
        String this$proprietorCompanyId = this.getProprietorCompanyId();
        String other$proprietorCompanyId = other.getProprietorCompanyId();
        if (this$proprietorCompanyId == null ? other$proprietorCompanyId != null : !this$proprietorCompanyId.equals(other$proprietorCompanyId)) {
            return false;
        }
        Point this$lonLat = this.getLonLat();
        Point other$lonLat = other.getLonLat();
        if (this$lonLat == null ? other$lonLat != null : !this$lonLat.equals(other$lonLat)) {
            return false;
        }
        Set<String> this$resourceTypes = this.getResourceTypes();
        Set<String> other$resourceTypes = other.getResourceTypes();
        if (this$resourceTypes == null ? other$resourceTypes != null : !((Object)this$resourceTypes).equals(other$resourceTypes)) {
            return false;
        }
        Timestamp this$lastSyncTime = this.getLastSyncTime();
        Timestamp other$lastSyncTime = other.getLastSyncTime();
        if (this$lastSyncTime == null ? other$lastSyncTime != null : !((Object)this$lastSyncTime).equals(other$lastSyncTime)) {
            return false;
        }
        Set<String> this$scopePermissions = this.getScopePermissions();
        Set<String> other$scopePermissions = other.getScopePermissions();
        return !(this$scopePermissions == null ? other$scopePermissions != null : !((Object)this$scopePermissions).equals(other$scopePermissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdDeviceDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $dispatchable = this.getDispatchable();
        result = result * 59 + ($dispatchable == null ? 43 : ((Object)$dispatchable).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $dispatchNo = this.getDispatchNo();
        result = result * 59 + ($dispatchNo == null ? 43 : $dispatchNo.hashCode());
        String $deviceUid = this.getDeviceUid();
        result = result * 59 + ($deviceUid == null ? 43 : $deviceUid.hashCode());
        String $deviceNo = this.getDeviceNo();
        result = result * 59 + ($deviceNo == null ? 43 : $deviceNo.hashCode());
        String $deviceModel = this.getDeviceModel();
        result = result * 59 + ($deviceModel == null ? 43 : $deviceModel.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $organizationName = this.getOrganizationName();
        result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
        String $securityStationId = this.getSecurityStationId();
        result = result * 59 + ($securityStationId == null ? 43 : $securityStationId.hashCode());
        String $securityStationName = this.getSecurityStationName();
        result = result * 59 + ($securityStationName == null ? 43 : $securityStationName.hashCode());
        DeviceType $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        DeviceStatus $deviceStatus = this.getDeviceStatus();
        result = result * 59 + ($deviceStatus == null ? 43 : $deviceStatus.hashCode());
        String $proprietorCompanyName = this.getProprietorCompanyName();
        result = result * 59 + ($proprietorCompanyName == null ? 43 : $proprietorCompanyName.hashCode());
        String $proprietorCompanyId = this.getProprietorCompanyId();
        result = result * 59 + ($proprietorCompanyId == null ? 43 : $proprietorCompanyId.hashCode());
        Point $lonLat = this.getLonLat();
        result = result * 59 + ($lonLat == null ? 43 : $lonLat.hashCode());
        Set<String> $resourceTypes = this.getResourceTypes();
        result = result * 59 + ($resourceTypes == null ? 43 : ((Object)$resourceTypes).hashCode());
        Timestamp $lastSyncTime = this.getLastSyncTime();
        result = result * 59 + ($lastSyncTime == null ? 43 : ((Object)$lastSyncTime).hashCode());
        Set<String> $scopePermissions = this.getScopePermissions();
        result = result * 59 + ($scopePermissions == null ? 43 : ((Object)$scopePermissions).hashCode());
        return result;
    }

    public String toString() {
        return "RdDeviceDocument(id=" + this.getId() + ", keyword=" + this.getKeyword() + ", dispatchNo=" + this.getDispatchNo() + ", deviceUid=" + this.getDeviceUid() + ", deviceNo=" + this.getDeviceNo() + ", deviceModel=" + this.getDeviceModel() + ", organizationId=" + this.getOrganizationId() + ", organizationName=" + this.getOrganizationName() + ", securityStationId=" + this.getSecurityStationId() + ", securityStationName=" + this.getSecurityStationName() + ", deviceType=" + this.getDeviceType() + ", deviceStatus=" + this.getDeviceStatus() + ", dispatchable=" + this.getDispatchable() + ", proprietorCompanyName=" + this.getProprietorCompanyName() + ", proprietorCompanyId=" + this.getProprietorCompanyId() + ", lonLat=" + this.getLonLat() + ", resourceTypes=" + this.getResourceTypes() + ", lastSyncTime=" + this.getLastSyncTime() + ", scopePermissions=" + this.getScopePermissions() + ")";
    }
}

