package com.bcxin.signature;

import com.alibaba.fastjson.JSON;
import com.bcxin.backend.core.exceptions.CustomSystemErrorPrintStream;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.signature.config.FileModeConfig;
import com.bcxin.signature.util.ftp.FtpConnection;
import com.bcxin.signature.util.ftp.FtpUtil;
import com.bcxin.signature.util.ftp.ThreadFtpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
@EnableScheduling
@ServletComponentScan
public class Application extends SpringBootServletInitializer {
	/**
	 * 不使用内嵌tomcat的配置
	 */
	@Override
	protected SpringApplicationBuilder configure( SpringApplicationBuilder application) {
		return application.sources(Application.class);
	}

	private static final Logger log = LoggerFactory.getLogger(Application.class);

	public static void main(String[] args) {
			/*
		FileModeConfig config = new FileModeConfig();
		config.setHost("49.4.21.141");
		config.setPort(2136);
		config.setUserName("xftest");
		config.setPassword("xftest123%");
		FtpConnection topConnect = new FtpConnection();
		Collection<String> pendingFileNames = new ArrayList<>();
		pendingFileNames = FtpUtil.getFtpMetaFiles(topConnect);
		Collection<String> finalPendingFileNames = pendingFileNames;
		System.err.println("pending file="+pendingFileNames.stream().collect(Collectors.joining()));
		Consumer<Integer> consumer = (index)->{
			try {
				FtpConnection connection = new FtpConnection();

				String content = connection.getFileContent("", "INJTLZ-aaa.bcx");
				System.err.println(String.format("%s:%s---%s-%s;",new Date(), index, content, finalPendingFileNames.stream().collect(Collectors.joining())));
			} catch (Exception ex) {
				System.err.println("获取FTP文件异常:" + ExceptionUtils.getStackMessage(ex));
			}
		};
		Collection<CompletableFuture<?>> allFuthers = new ArrayList<>();
		for(int index=0;index<100;index++) {
			int finalIndex = index;
			allFuthers.add(CompletableFuture.runAsync(()->{
				consumer.accept(finalIndex);
			}));
		}

		CompletableFuture.allOf(allFuthers.toArray(new CompletableFuture[allFuthers.size()])).join();
		System.err.println("all for done");
		 */
		System.setErr(CustomSystemErrorPrintStream.instance);
		SpringApplication app = new SpringApplication(Application.class);
		Environment env = app.run(args).getEnvironment();
		log.info("\n----------------------------------------------------------\n\t" +
						"Application '{}' is running! Access URLs:\n\t" +
						"Local: \t\thttp://localhost:{}\n\t" +
						"----------------------------------------------------------",
				env.getProperty("spring.application.name"),
				env.getProperty("server.port"));
		String[] activeProfiles = env.getActiveProfiles();
		System.err.println("启动的配置文件为："+ JSON.toJSONString(activeProfiles));
	}
}
