/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.system.configs;

import com.bcxin.backend.domain.system.configs.DispatchProperties;
import com.bcxin.backend.domain.system.configs.DispatchSiteResourceProperties;
import com.bcxin.backend.domain.system.entities.UserDTO;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"com.bcxin.backend.domain.system.repositories"}, entityManagerFactoryRef="entityManagerFactory_system", transactionManagerRef="transactionManager_system")
@EnableConfigurationProperties(value={DispatchProperties.class, DispatchSiteResourceProperties.class})
public class SysConfig {
    @Bean(value={"entityManagerFactory_system"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryBean(@Qualifier(value="dataSource") DataSource dataSource, EntityManagerFactoryBuilder builder) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.hbm2ddl.auto", "none");
        properties.put("hibernate.show_sql", "true");
        return builder.dataSource(dataSource).properties(properties).packages(new Class[]{UserDTO.class}).build();
    }

    @Bean(value={"transactionManager_system"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="entityManagerFactory_system") LocalContainerEntityManagerFactoryBean entityManagerFactoryBean) {
        return new JpaTransactionManager(entityManagerFactoryBean.getObject());
    }
}

