/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import com.spire.pdf.FileFormat;
import com.spire.pdf.PdfDocument;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.ofdrw.tool.merge.OFDMerger;
import org.springframework.util.StringUtils;

public class PDFToOFDUtil {
    public static void main(String[] args) throws IOException {
        long startTime = System.nanoTime();
        String inputFilePath = "D:\\data\\queueId_32.pdf";
        List<String> listPfd = PDFToOFDUtil.splitPDFByPageCount(inputFilePath, 3);
        ArrayList<String> listOfd = new ArrayList<String>();
        for (String string : listPfd) {
            String replace = string.replace("pdf", "ofd");
            PDFToOFDUtil.transPdfToOfd(string, replace);
            listOfd.add(replace);
        }
        String outputFilePathOfd = inputFilePath.replace("pdf", "ofd");
        PDFToOFDUtil.mergeOfdFiles(listOfd, outputFilePathOfd);
        System.out.println("\u5b8c\u6574\u7248ofd\u6587\u4ef6\u8def\u5f84\uff1a" + outputFilePathOfd);
        listPfd.addAll(listOfd);
        for (String relFilePath : listPfd) {
            Files.deleteIfExists(Paths.get(relFilePath, new String[0]));
        }
        long l = System.nanoTime();
        double durationInSeconds = (double)(l - startTime) / 1.0E9;
        System.out.println("\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4: " + durationInSeconds + " \u79d2");
    }

    public static void transPdfToOfd(String pdfPath, String ofdPath) {
        if (StringUtils.isEmpty((Object)ofdPath) || StringUtils.isEmpty((Object)pdfPath)) {
            throw new RuntimeException("pdf\u6216ofd\u6587\u6863\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] bytes = PDFToOFDUtil.getBytesFromFile(new File(pdfPath));
        PDFToOFDUtil.transPdfToOfd(bytes, ofdPath);
    }

    public static void transPdfToOfd(byte[] pdfBytes, String ofdPath) {
        if (pdfBytes == null || pdfBytes.length <= 0) {
            throw new RuntimeException("pdf\u8f6cofd\u8f6c\u5316\u5931\u8d25\uff0cpdf\u6587\u4ef6\u9519\u8bef\uff0cpdf\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)ofdPath)) {
            throw new RuntimeException("ofd\u6587\u6863\u8f93\u51fa\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long startTime = LocalDateTime.now().atOffset(ZoneOffset.of("+8")).toInstant().toEpochMilli();
        PdfDocument pdf = new PdfDocument();
        pdf.loadFromBytes(pdfBytes);
        pdf.saveToFile(ofdPath, FileFormat.OFD);
        long endTime = LocalDateTime.now().atOffset(ZoneOffset.of("+8")).toInstant().toEpochMilli();
    }

    public static byte[] getBytesFromFile(File file) {
        byte[] data;
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(inputStream);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            data = bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public static void mergePdfFiles(List<String> pdfFiles, String mergedPdf) throws IOException, DocumentException {
        Document document = new Document();
        PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(mergedPdf));
        document.open();
        for (String file : pdfFiles) {
            PdfReader reader = new PdfReader(file);
            int n = reader.getNumberOfPages();
            int page = 0;
            while (page < n) {
                copy.addPage(copy.getImportedPage(reader, ++page));
            }
            copy.freeReader(reader);
            reader.close();
        }
        document.close();
    }

    public static void mergeOfdFiles(List<String> ofdFiles, String mergeOfd) {
        Path dst = Paths.get(mergeOfd, new String[0]);
        try (OFDMerger ofdMerger = new OFDMerger(dst);){
            for (String ofdFile : ofdFiles) {
                Path d1Path = Paths.get(ofdFile, new String[0]);
                ofdMerger.add(d1Path, new int[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> splitPDFByPageCount(String inputFilePath, int pagesPerFile) {
        ArrayList<String> listPdf = new ArrayList<String>();
        try {
            File inputFile = new File(inputFilePath);
            PDDocument document = PDDocument.load((File)inputFile);
            String outputDirPath = inputFile.getParent();
            File outputDir = new File(outputDirPath);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            int totalPages = document.getNumberOfPages();
            int numFiles = (int)Math.ceil((double)totalPages / (double)pagesPerFile);
            for (int fileIndex = 0; fileIndex < numFiles; ++fileIndex) {
                PDDocument singleFileDoc = new PDDocument();
                int startPage = fileIndex * pagesPerFile;
                int endPage = Math.min(startPage + pagesPerFile, totalPages);
                for (int pageIndex = startPage; pageIndex < endPage; ++pageIndex) {
                    PDPage page = document.getPage(pageIndex);
                    singleFileDoc.addPage(page);
                }
                String outputFileName = outputDirPath + "/output-part-" + (fileIndex + 1) + ".pdf";
                singleFileDoc.save(outputFileName);
                singleFileDoc.close();
                listPdf.add(outputFileName);
            }
            document.close();
            System.out.println("PDF \u6309\u9875\u6570\u5206\u9694\u5b8c\u6210\uff0c\u6587\u4ef6\u5df2\u4fdd\u5b58\u5230\uff1a" + outputDirPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return listPdf;
    }
}

