package com.bcxin.backend.domain.syncs.repositories;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.bcxin.runtime.domain.syncs.entities.FileSyncQueueEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface FileSyncQueueRepository extends JpaRepository<FileSyncQueueEntity,String> {
    @Query("select d from FileSyncQueueEntity d where d.isDownloaded=com.bcxin.runtime.domain.enums.BooleanStatus.FALSE and d.lastProcessedTime is null")
    public Page<FileSyncQueueEntity> getPendings(Pageable pageable);
}
