package com.bcxin.backend.domain.configs;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

@Configuration
public class GovernmentConfig {

    @Bean(name = "governmentDataSource")
    @Qualifier("governmentDataSource")
    @ConfigurationProperties(prefix="spring.datasource.nx-government")
    public DataSource governmentDataSource() {
        return DataSourceBuilder.create().build();
    }


    @Bean(name="governmentJdbcTemplate")
    public JdbcTemplate primaryJdbcTemplate (
            @Qualifier("governmentDataSource")  DataSource dataSource ) {
        return new JdbcTemplate(dataSource);
    }
}
