/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.components;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public class JTLZComponent {
    private static final Logger logger = LoggerFactory.getLogger(JTLZComponent.class);
    private static final String LICENSE_LOGIN = "/license-app/v1/security/login";
    private static final String LICENSE_ISSUE = "/license-app/v1/license/{item_code}/issue?access_token=";
    private static final String LICENSE_ABOLISH = "/license-app/v1/license/{item_code}/abolish?access_token=";
    private static Map<String, Instant> tokenMap = new HashMap();
    private final String ip_address;
    private final String app_key;
    private final String app_secret;
    private final String account;
    private final String password;

    public JTLZComponent(@Value(value="${myapps.signature.license.ip_address}") String ip_address, @Value(value="${myapps.signature.license.app_key}") String app_key, @Value(value="${myapps.signature.license.app_secret}") String app_secret, @Value(value="${myapps.signature.license.account}") String account, @Value(value="${myapps.signature.license.password}") String password) {
        this.ip_address = ip_address;
        this.app_key = app_key;
        this.app_secret = app_secret;
        this.account = account;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateToken() {
        String string;
        String token;
        Exception lastException;
        StopWatch stopWatch;
        block7: {
            String ret;
            block6: {
                stopWatch = new StopWatch();
                stopWatch.start();
                lastException = null;
                token = "";
                JSONObject json = new JSONObject();
                json.put("app_key", (Object)this.app_key);
                json.put("app_secret", (Object)this.app_secret);
                json.put("account", (Object)this.account);
                json.put("password", (Object)this.password);
                ret = HttpUtil.post((String)(this.ip_address + LICENSE_LOGIN), (String)json.toJSONString());
                if (!StringUtils.isEmpty((CharSequence)ret)) break block6;
                String string2 = token;
                stopWatch.stop();
                logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "success" : "failed", lastException, stopWatch.getTotalTimeSeconds()});
                return string2;
            }
            JSONObject result = JSONObject.parseObject((String)ret);
            String ack_code = result.getString("ack_code");
            token = result.getString("access_token");
            if ("SUCCESS".equals(ack_code) && !StringUtils.isEmpty((CharSequence)token)) break block7;
            String string3 = token;
            stopWatch.stop();
            logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "success" : "failed", lastException, stopWatch.getTotalTimeSeconds()});
            return string3;
        }
        try {
            tokenMap = new HashMap();
            tokenMap.put(token, Instant.now());
            string = token;
        }
        catch (Exception e) {
            String string4;
            try {
                lastException = e;
                string4 = token;
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "success" : "failed", lastException, stopWatch.getTotalTimeSeconds()});
                throw throwable;
            }
            stopWatch.stop();
            logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "success" : "failed", lastException, stopWatch.getTotalTimeSeconds()});
            return string4;
        }
        stopWatch.stop();
        logger.error("====> {} \u4eac\u901a\u9753\u8bc1\u83b7\u53d6token.license_login. \u8017\u65f6 {} \u79d2", new Object[]{lastException == null ? "success" : "failed", lastException, stopWatch.getTotalTimeSeconds()});
        return string;
    }

    public String getLicenseToken() {
        Instant now = Instant.now();
        if (tokenMap.isEmpty()) {
            return this.generateToken();
        }
        String latestToken = null;
        Instant latestTime = null;
        for (Map.Entry entry : tokenMap.entrySet()) {
            if (latestTime != null && !((Instant)entry.getValue()).isAfter(latestTime)) continue;
            latestToken = (String)entry.getKey();
            latestTime = (Instant)entry.getValue();
        }
        Duration duration = Duration.between(latestTime, now);
        if (duration.toHours() >= 6L) {
            return this.generateToken();
        }
        return latestToken;
    }

    public String license_issue(String item_code, String body) {
        String pathApi = null;
        try {
            String token = this.getLicenseToken();
            pathApi = this.ip_address + LICENSE_ISSUE.replace("{item_code}", item_code) + token;
            String ret = HttpUtil.post((String)pathApi, (String)body);
            return ret;
        }
        catch (Exception e) {
            logger.error("====> 2.fail to JTLZ schedule task job.license_issue.err\uff1a(item_code={},pathAPI={})}", new Object[]{item_code, pathApi, e});
            return "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + e.getMessage() + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String license_issue_fz(String item_code, String body) {
        String string;
        Exception lastException = null;
        String ret = null;
        String pathApi = null;
        try {
            pathApi = this.ip_address + LICENSE_ABOLISH.replace("{item_code}", item_code) + this.getLicenseToken();
            string = ret = HttpUtil.post((String)pathApi, (String)body);
        }
        catch (Exception e) {
            String string2;
            try {
                lastException = e;
                string2 = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + e.getMessage() + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
            }
            catch (Throwable throwable) {
                logger.error("===> {} \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8fd4\u56de\u62a5\u6587(api=>{},body={}):{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", pathApi, body, ret, lastException});
                throw throwable;
            }
            logger.error("===> {} \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8fd4\u56de\u62a5\u6587(api=>{},body={}):{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", pathApi, body, ret, lastException});
            return string2;
        }
        logger.error("===> {} \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8fd4\u56de\u62a5\u6587(api=>{},body={}):{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", pathApi, body, ret, lastException});
        return string;
    }
}

