/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import com.bcxin.backend.core.exceptions.SaasRetryableException;
import com.bcxin.backend.core.utils.RetryUtil;
import com.bcxin.signature.config.FileModeConfig;
import com.bcxin.signature.util.ftp.FtpClientPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FtpConnection {
    private static final Logger log = LoggerFactory.getLogger(FtpConnection.class);
    private static FtpClientPool ftpClientPool = new FtpClientPool(5, FileModeConfig.getHost(), FileModeConfig.getPort(), FileModeConfig.getUserName(), FileModeConfig.getPassword());
    private static Object _staticInstanceLock = new Object();

    private FTPClient getFtp() {
        return ftpClientPool.borrowConnection();
    }

    private void returnFtp(FTPClient client) {
        if (client != null) {
            ftpClientPool.returnConnection(client);
        }
    }

    protected static void reconnect(FTPClient ftpClient) {
        try {
            FtpConnection.initConnect((FTPClient)ftpClient, (String)FileModeConfig.getHost(), (int)FileModeConfig.getPort(), (String)FileModeConfig.getUserName(), (String)FileModeConfig.getPassword());
        }
        catch (IOException e) {
            log.error("ftp connect exception:host={};username={}", new Object[]{FileModeConfig.getHost(), FileModeConfig.getUserName(), e});
            throw new RuntimeException("failed to connect ftp", e);
        }
    }

    private static void initConnect(FTPClient ftpClient, String host, int port, String user, String password) throws IOException {
        try {
            if (!ftpClient.isConnected()) {
                ftpClient.connect(host, port);
            }
        }
        catch (UnknownHostException ex) {
            throw new IOException("Can't find FTP server '" + host + "'");
        }
        ftpClient.enterLocalPassiveMode();
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            FtpConnection.disconnect();
            throw new IOException("Can't connect to server '" + host + "'");
        }
        if (!ftpClient.login(user, password)) {
            FtpConnection.disconnect();
            throw new IOException("Can't login to server '" + host + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadBase64(String path, String ftpFileName, String base64Content) throws IOException {
        boolean is = false;
        if (base64Content == null || base64Content.isEmpty()) {
            throw new IOException("Can't upload. The base64 content is empty.");
        }
        FtpConnection.conv((String)path, (String)ftpFileName);
        if (FtpConnection.hasChineseUsingRegex((String)ftpFileName)) {
            return is;
        }
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
            this.setWorkingDirectory(path);
        }
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        byte[] decodedBytes = base64Content.getBytes();
        FTPClient ftpClient = null;
        try {
            ftpClient = this.getFtp();
            try (ByteArrayInputStream in = new ByteArrayInputStream(decodedBytes);){
                String filePath = path + "/" + ftpFileName;
                filePath = filePath.replace("\\", "/");
                ftpClient.setFileType(2);
                is = ftpClient.storeFile(filePath, (InputStream)in);
            }
            catch (Exception e) {
                log.error("failed to uploadBase64 file", (Throwable)e);
            }
        }
        finally {
            this.returnFtp(ftpClient);
        }
        return is;
    }

    private static void conv(String path, String ftpFileName) {
        ftpFileName = ftpFileName.startsWith("/") ? ftpFileName : "/" + ftpFileName;
        Path sourcePath = Paths.get(path + ftpFileName, new String[0]);
        if (sourcePath.getParent() != null) {
            path = sourcePath.getParent().toAbsolutePath().toString();
        }
        ftpFileName = sourcePath.getFileName().toString();
    }

    public static boolean hasChineseUsingRegex(String str) {
        return str.matches(".*[\u4e00-\u9fa5]+.*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String path, String ftpFileName, File localFile) throws IOException {
        boolean is = false;
        if (localFile.exists()) {
            throw new IOException("Can't download '" + localFile.getAbsolutePath() + "'. This file already exists.");
        }
        FtpConnection.conv((String)path, (String)ftpFileName);
        if (FtpConnection.hasChineseUsingRegex((String)ftpFileName)) {
            return is;
        }
        System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6307\u5b9a\u6587\u4ef6\u8f6c\u5b58,ftp\u8def\u5f84\uff1a" + path + ",\u6587\u4ef6\u540d\uff1a" + ftpFileName + "<=======");
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6307\u5b9a\u6587\u4ef6\u8f6c\u5b58,\u8282\u70b9\uff1a101<=======");
            this.setWorkingDirectory(path);
        }
        ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
        System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6307\u5b9a\u6587\u4ef6\u8f6c\u5b58,\u8282\u70b9\uff1a102<=======");
        FTPClient ftpClient = null;
        try {
            ftpClient = this.getFtp();
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
                String filePath = path + "/" + ftpFileName;
                filePath = filePath.replace("\\", "/");
                System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6307\u5b9a\u6587\u4ef6,\u5b9e\u9645\u8def\u5f84\uff1a" + filePath + "<=======");
                ftpClient.setFileType(2);
                is = ftpClient.retrieveFile(filePath, (OutputStream)out);
            }
            catch (Exception e) {
                System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6307\u5b9a\u6587\u4ef6\u8f6c\u5b58,\u8282\u70b9\uff1a103<=======");
                e.printStackTrace();
                log.error("");
            }
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6307\u5b9a\u6587\u4ef6\u8f6c\u5b58,\u8282\u70b9\uff1a104<=======");
            boolean bl = is;
            return bl;
        }
        finally {
            this.returnFtp(ftpClient);
        }
    }

    /*
     * Exception decompiling
     */
    public String downloadAsBase64(String path, String ftpFileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContent(String path, String ftpFileName) throws IOException {
        String string;
        block25: {
            InputStream inputStream;
            String remoteFile;
            StringBuilder sb;
            StringBuilder content;
            block22: {
                String string2;
                block23: {
                    FtpConnection.conv((String)path, (String)ftpFileName);
                    if (StringUtils.isNotEmpty((CharSequence)path)) {
                        path = new String(path.getBytes("GBK"), "iso-8859-1");
                        this.setWorkingDirectory(path);
                    }
                    ftpFileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
                    content = new StringBuilder();
                    String string3 = ftpFileName = ftpFileName.startsWith("/") ? ftpFileName : "/" + ftpFileName;
                    if (FtpConnection.hasChineseUsingRegex((String)ftpFileName)) {
                        log.error("[BAD-ERROR]--the file does not match expected:{}", (Object)ftpFileName);
                        return "";
                    }
                    sb = new StringBuilder();
                    remoteFile = path + ftpFileName;
                    sb.append(String.format("org-remote-file=%s;", remoteFile));
                    if (StringUtils.isBlank((CharSequence)path) && ftpFileName.startsWith("/")) {
                        ftpFileName = ftpFileName.substring(1);
                        remoteFile = path + ftpFileName;
                        sb.append(String.format("re-org-remote-file=%s;", remoteFile));
                    }
                    inputStream = null;
                    String finalRemoteFile = remoteFile;
                    AtomicInteger retryCount = new AtomicInteger(0);
                    inputStream = (InputStream)RetryUtil.execute(() -> {
                        InputStream is = null;
                        Object object = _staticInstanceLock;
                        synchronized (object) {
                            FTPClient selectedFtpClient = null;
                            try {
                                selectedFtpClient = this.getFtp();
                                is = selectedFtpClient.retrieveFileStream(finalRemoteFile);
                            }
                            finally {
                                this.returnFtp(selectedFtpClient);
                            }
                        }
                        if (is == null) {
                            retryCount.incrementAndGet();
                            Collection matchedFiles = this.getMatchFileNames(finalRemoteFile, 10);
                            if (!CollectionUtils.isEmpty((Collection)matchedFiles)) {
                                throw new SaasRetryableException(String.format("can not read remoteFile=%s;", finalRemoteFile));
                            }
                        }
                        if (retryCount.get() > 0) {
                            log.error("After retry success to get content with retryCount={};file={}", (Object)retryCount, (Object)finalRemoteFile);
                        }
                        return is;
                    });
                    if (inputStream != null) break block22;
                    sb.append("EMPTY;");
                    string2 = "";
                    if (inputStream == null) break block23;
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                return string2;
            }
            try {
                try (BufferedInputStream in = new BufferedInputStream(inputStream);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)in).read(buffer)) != -1) {
                        content.append(new String(buffer, 0, length, "UTF-8"));
                    }
                    sb.append("OK");
                    log.warn("Success to read content:{}", (Object)sb);
                }
                catch (Exception e) {
                    log.error("failed to read content(remoteFile={}, track={})", new Object[]{remoteFile, sb, e});
                    throw new RuntimeException(String.format("getFileContent exception:path=%s;fileName=%s;track=%s", path, ftpFileName, sb), e);
                }
                string = content.toString();
                if (inputStream == null) break block25;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    IOUtils.closeQuietly(inputStream);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> fileNames(String path, String keywork) throws IOException {
        if (StringUtils.isEmpty((CharSequence)keywork)) {
            keywork = "IN-";
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = this.getFtp();
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1,ftp\u8def\u5f84\uff1a" + path + ",\u5173\u952e\u5b57\uff1a" + keywork + "<=======");
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a001.1<=======");
                path = new String(path.getBytes("GBK"), "iso-8859-1");
                this.setWorkingDirectory(path);
                System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a001<=======");
            }
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a002<=======");
            ArrayList<String> recentFiles = new ArrayList<String>();
            FTPFile[] files = ftpClient.listFiles();
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u8282\u70b9\uff1a003<=======");
            long currentTime = System.currentTimeMillis();
            long fiveMinutesAgo = currentTime - 300000L;
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u6570\u91cf\uff1a" + files.length + "<=======");
            for (FTPFile file : files) {
                System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u7684\u540d\u79f0.filename\uff1a" + file.getName() + "<=======");
                Long fileTime = file.getTimestamp().getTimeInMillis() + (long)file.getTimestamp().getTimeZone().getOffset(0L);
                if (!file.isFile() || fileTime < fiveMinutesAgo || !file.getName().startsWith(keywork)) continue;
                System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6587\u4ef6\u4e1a\u52a1\u6709\u6548\u6587\u4ef6\u540d\uff1a" + file.getName() + "<=======");
                recentFiles.add(file.getName());
            }
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6700\u8fd15\u5206\u949f\u5185\u751f\u6210\u7684\u6587\u4ef6\u7684\u6570\u91cf\uff1a" + recentFiles.size() + "<=======");
            ArrayList<String> arrayList = recentFiles;
            return arrayList;
        }
        finally {
            this.returnFtp(ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delectFile(String path, String filename) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = new String(path.getBytes("GBK"), "iso-8859-1");
            this.setWorkingDirectory(path);
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = this.getFtp();
            boolean bl = ftpClient.deleteFile(filename);
            return bl;
        }
        finally {
            this.returnFtp(ftpClient);
        }
    }

    public static void disconnect() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setWorkingDirectory(String dir) {
        block5: {
            boolean bl;
            if (!this.createDirecroty(dir)) break block5;
            FTPClient ftpClient = null;
            try {
                ftpClient = this.getFtp();
                bl = ftpClient.changeWorkingDirectory(dir);
            }
            catch (Throwable throwable) {
                try {
                    this.returnFtp(ftpClient);
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.returnFtp(ftpClient);
            return bl;
        }
        return false;
    }

    public boolean isConnected() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDirecroty(String remote) throws IOException {
        if (StringUtils.isEmpty((CharSequence)remote)) {
            return false;
        }
        boolean success = true;
        String directory = remote.substring(0, remote.lastIndexOf("/") + 1);
        FTPClient ftpClient = null;
        try {
            ftpClient = this.getFtp();
            if (!directory.equalsIgnoreCase("/") && !ftpClient.changeWorkingDirectory(new String(directory))) {
                int start = 0;
                int end = 0;
                start = directory.startsWith("/") ? 1 : 0;
                end = directory.indexOf("/", start);
                do {
                    String subDirectory;
                    if (ftpClient.changeWorkingDirectory(subDirectory = new String(remote.substring(start, end)))) continue;
                    if (ftpClient.makeDirectory(subDirectory)) {
                        ftpClient.changeWorkingDirectory(subDirectory);
                        continue;
                    }
                    log.error("mack directory error :/" + subDirectory);
                    boolean bl = false;
                    return bl;
                } while ((end = directory.indexOf("/", start = end + 1)) > start);
            }
        }
        finally {
            this.returnFtp(ftpClient);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getMetaFileNames(String prefix, int limit) {
        Collection<String> fileNames = new ArrayList();
        Exception lastException = null;
        StringBuilder trace = new StringBuilder();
        if (limit < 1) {
            limit = 20;
        }
        boolean successInGetPendingFiles = false;
        try {
            fileNames = this.getMatchFileNames(prefix, limit);
        }
        catch (Exception ex) {
            try {
                lastException = ex;
                successInGetPendingFiles = false;
            }
            catch (Throwable throwable) {
                log.error("[IMPORTANT-{}] getMetaFileNames(fileNames.length={},successInGetPendingFiles={}): trace={}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", fileNames.size(), successInGetPendingFiles, trace, lastException});
                throw throwable;
            }
            log.error("[IMPORTANT-{}] getMetaFileNames(fileNames.length={},successInGetPendingFiles={}): trace={}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", fileNames.size(), successInGetPendingFiles, trace, lastException});
        }
        log.error("[IMPORTANT-{}] getMetaFileNames(fileNames.length={},successInGetPendingFiles={}): trace={}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", fileNames.size(), successInGetPendingFiles, trace, lastException});
        return fileNames;
    }

    private Collection<String> getMatchFileNames(String prefix, int limit) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        RetryUtil.execute(() -> {
            String[] fnames = null;
            FTPClient ftpClient = this.getFtp();
            try {
                fnames = ftpClient.listNames();
            }
            catch (Exception ex) {
                throw new SaasRetryableException("failed to fetch listNames", ex);
            }
            finally {
                this.returnFtp(ftpClient);
            }
            Collection matchedNames = new ArrayList();
            if (fnames != null) {
                matchedNames = Arrays.stream(fnames).filter(ii -> ii.startsWith(prefix)).sorted(Comparator.reverseOrder()).limit(limit).collect(Collectors.toList());
                log.error("listNames = size={};content={}", (Object)fnames.length, Arrays.stream(fnames).findFirst().orElse(null));
            }
            return matchedNames;
        });
        return fileNames;
    }
}

