/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Level;

public class EMQFetcher
extends HttpBase {
    public EMQFetcher(String security) {
        super(security);
    }

    public EMQFetcher(String security, Region region) {
        super(security, region);
    }

    public String fetchAckInfo(String packageName, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        String result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to fetch ack info ");
            }
            boolean bl = tryAgain = (result = this.fetchAckInfoNoRetry("package_name=" + packageName)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String fetchClickInfo(String packageName, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        String result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to fetch click info ");
            }
            boolean bl = tryAgain = (result = this.fetchClickInfoNoRetry("package_name=" + packageName)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String fetchInvalidRegId(String packageName, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        String result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to fetch invalid regid ");
            }
            boolean bl = tryAgain = (result = this.fetchInvalidRegIdNoRetry("package_name=" + packageName)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String fetchAckInfoNoRetry(String packageName) throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            conn = this.doGet(Constants.XmPushRequestPath.V1_EMQ_ACK_INFO, packageName);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while fetch ack info: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = EMQFetcher.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = EMQFetcher.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    private String fetchClickInfoNoRetry(String packageName) throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            conn = this.doGet(Constants.XmPushRequestPath.V1_EMQ_CLICK_INFO, packageName);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while fetch click info: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = EMQFetcher.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = EMQFetcher.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    private String fetchInvalidRegIdNoRetry(String packageName) throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            conn = this.doGet(Constants.XmPushRequestPath.V1_EMQ_INVALID_REGID, packageName);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while fetch invalid regId: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = EMQFetcher.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = EMQFetcher.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }
}

