/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tracer
extends HttpBase {
    protected static final Logger logger = Logger.getLogger(Tracer.class.getName());

    public Tracer(String security) {
        super(Tracer.nonNull(security));
    }

    public Tracer(String security, Region region) {
        super(Tracer.nonNull(security), region);
    }

    public String getMessageGroupStatus(String jobKey, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get status of message group " + jobKey);
            }
            boolean bl = tryAgain = (result = this.getMessageGroupStatusNoRetry(jobKey)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getMessageStatus(String msgId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get status of message " + msgId);
            }
            boolean bl = tryAgain = (result = this.getMessageStatusNoRetry(msgId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getMessageStatus(long beginTime, long endTime, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get messages status between " + beginTime + " and " + endTime);
            }
            boolean bl = tryAgain = (result = this.getMessageStatusNoRetry(beginTime, endTime)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getMessageGroupStatusNoRetry(String jobKey) throws UnsupportedEncodingException, InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = Tracer.newBody("job_key", URLEncoder.encode(jobKey, "UTF-8"));
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_MESSAGE_STATUS);
            conn = this.doGet(Constants.XmPushRequestPath.V1_MESSAGE_STATUS, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.FINE, "IOException while get from XmPush: server " + this.remoteHost + " ip " + this.remoteIp, e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Tracer.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Tracer.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    public String getMessageStatusNoRetry(String msgId) throws UnsupportedEncodingException, InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = Tracer.newBody("msg_id", URLEncoder.encode(msgId, "UTF-8"));
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_MESSAGE_STATUS);
            conn = this.doGet(Constants.XmPushRequestPath.V1_MESSAGE_STATUS, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.FINE, "IOException while get from XmPush: server " + this.remoteHost + " ip " + this.remoteIp, e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Tracer.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                this.lastException = e;
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Tracer.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        return responseBody;
    }

    public String getMessageStatusNoRetry(long beginTime, long endTime) throws UnsupportedEncodingException, InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = Tracer.newBody("begin_time", URLEncoder.encode("" + beginTime, "UTF-8"));
        Tracer.addParameter(parameter, "end_time", URLEncoder.encode("" + endTime, "UTF-8"));
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_MESSAGES_STATUS);
            conn = this.doGet(Constants.XmPushRequestPath.V1_MESSAGES_STATUS, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.FINE, "IOException while get from XmPush: server " + this.remoteHost + " ip " + this.remoteIp, e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Tracer.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Tracer.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        return responseBody;
    }
}

