/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import com.xiaomi.xmpush.server.XMStringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;

public class MessageRevoker
extends HttpBase {
    public MessageRevoker(String security) {
        super(MessageRevoker.nonNull(security));
    }

    public MessageRevoker(String security, Region region) {
        super(MessageRevoker.nonNull(security), region);
    }

    public String revokeMessage(String packageName, String title, String description, int notifyId, String[] topics, String msgId, int retries) throws IOException {
        boolean tryAgain;
        StringBuilder body = new StringBuilder("");
        if (!XMStringUtils.isEmpty(packageName)) {
            MessageRevoker.addParameter(body, "restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(title)) {
            MessageRevoker.addParameter(body, "title", URLEncoder.encode(title, "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(description)) {
            MessageRevoker.addParameter(body, "description", URLEncoder.encode(description, "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(Integer.toString(notifyId))) {
            MessageRevoker.addParameter(body, "notify_id", URLEncoder.encode(Integer.toString(notifyId), "UTF-8"));
        }
        if (topics != null && topics.length != 0) {
            for (String topic : topics) {
                MessageRevoker.addParameter(body, "topics", URLEncoder.encode(topic, "UTF-8"));
            }
        }
        if (!XMStringUtils.isEmpty(msgId)) {
            MessageRevoker.addParameter(body, "msg_id", URLEncoder.encode(msgId, "UTF-8"));
        }
        String strBody = body.toString();
        int attempt = 0;
        String result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to revoke message.");
            }
            boolean bl = tryAgain = (result = this.revokeMessageNoRetry(strBody)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String revokeMessageNoRetry(String params) throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            conn = this.doPost(Constants.XmPushRequestPath.V1_REVOKE_MESSAGE, params);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while fetch revoke message: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = MessageRevoker.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = MessageRevoker.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }
}

