/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;

public class DevTools
extends HttpBase {
    private static final String REG_ID_SPLITTER = ",";

    public DevTools(String security) {
        super(DevTools.nonNull(security));
    }

    public DevTools(String security, Region region) {
        super(DevTools.nonNull(security), region);
    }

    public String getAliasesOf(String packageName, String regId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get all aliases of the device.");
            }
            boolean bl = tryAgain = (result = this.getAliasesNoRetry(packageName, regId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getTopicsOf(String packageName, String regId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get all topics of the device.");
            }
            boolean bl = tryAgain = (result = this.getTopicsNoRetry(packageName, regId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getAccountsOf(String packageName, String regId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get all user account of the device.");
            }
            boolean bl = tryAgain = (result = this.getAccountsNoRetry(packageName, regId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getPresence(String packageName, String regId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get presence of the device.");
            }
            boolean bl = tryAgain = (result = this.getPresenceNoRetry(packageName, regId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getPresence(String packageName, List<String> regIds, int retries) throws IOException {
        StringBuilder sb = new StringBuilder(regIds.get(0));
        for (int i = 1; i < regIds.size(); ++i) {
            sb.append(REG_ID_SPLITTER).append(regIds.get(i));
        }
        return this.getPresence(packageName, sb.toString(), retries);
    }

    protected String getAliasesNoRetry(String packageName, String regId) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = DevTools.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            DevTools.addParameter(sb, "registration_id", URLEncoder.encode(regId, "UTF-8"));
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_GET_ALL_ALIAS);
            conn = this.doGet(Constants.XmPushRequestPath.V1_GET_ALL_ALIAS, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while get alias: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            try {
                responseBody = DevTools.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody);
            }
            catch (IOException e) {
                responseBody = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody);
        }
        try {
            responseBody = DevTools.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    protected String getTopicsNoRetry(String packageName, String regId) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = DevTools.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            DevTools.addParameter(sb, "registration_id", URLEncoder.encode(regId, "UTF-8"));
            conn = this.doGet(Constants.XmPushRequestPath.V1_GET_ALL_TOPIC, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.WARNING, "IOException while get topic: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + ") remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            try {
                responseBody = DevTools.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody);
            }
            catch (IOException e) {
                responseBody = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody);
        }
        try {
            responseBody = DevTools.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    protected String getAccountsNoRetry(String packageName, String regId) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = DevTools.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            DevTools.addParameter(sb, "registration_id", URLEncoder.encode(regId, "UTF-8"));
            conn = this.doGet(Constants.XmPushRequestPath.V1_GET_ALL_ACCOUNT, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while get user-account: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            try {
                responseBody = DevTools.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody);
            }
            catch (IOException e) {
                responseBody = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody);
        }
        try {
            responseBody = DevTools.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    protected String getPresenceNoRetry(String packageName, String regId) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            StringBuilder sb = DevTools.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            DevTools.addParameter(sb, "registration_id", URLEncoder.encode(regId, "UTF-8"));
            conn = regId.contains(REG_ID_SPLITTER) ? this.doGet(Constants.XmPushRequestPath.V2_REGID_PRESENCE, sb.toString()) : this.doGet(Constants.XmPushRequestPath.V1_REGID_PRESENCE, sb.toString());
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while get presence: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("Service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            try {
                responseBody = DevTools.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody);
            }
            catch (IOException e) {
                responseBody = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody);
        }
        try {
            responseBody = DevTools.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }
}

