/**
 * @module 1-liners/propertyIsEnumerable
 *
 * @description
 *
 * Returns a Boolean indicating whether the specified property is enumerable.
 *
 * @example
 *
 * const FOO = {
 *  'bar' : 'bar'
 * }
 * FOO.propertyIsEnumerable('bar') // => true
 * FOO.propertyIsEnumerable('length') // => false
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (obj, property) {
  return obj.propertyIsEnumerable(property);
};

module.exports = exports["default"];