/**
 * @module 1-liners/pipeAll
 * 
 * @description
 *
 * Pipe arguments through an array of functions.
 * 
 * @example
 * 
 * 	const pipeAll = require('1-liners/pipeAll');
 * 
 * 	pipeAll([f, g, h])(1, 2) === h(g(f(1, 2)));
 * 
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (fns) {
  return fns.reduceRight(function (f, g) {
    return function () {
      return f(g.apply(undefined, arguments));
    };
  });
};

module.exports = exports["default"];