/**
 * @module 1-liners/pick
 *
 * @description
 *
 * Copies only specified `properties` from an `object` into a new object.
 *
 * @example
 *
 * 	const pick = require('1-liners/pick');
 *
 * 	const object = {foo: 1, bar: 2, baz: 3};
 *
 * 	pick(['foo', 'baz'], object);  // => {foo: 1, baz: 3}
 *
 */
"use strict";

exports.__esModule = true;
// istanbul ignore next

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports["default"] = function (properties, object) {
  return _extends.apply(undefined, [{}].concat(properties.map(function (key) {
    // istanbul ignore next

    var _ref;

    return _ref = {}, _ref[key] = object[key], _ref;
  })));
};

module.exports = exports["default"];