/**
 * @module 1-liners/once
 *
 * @description
 *
 * Creates a function that is restricted to invoking passed function once.
 *
 * @example
 *
 * const once = require('1-liners/once');
 * let count = 0;
 * let countOnce = once(() => ++count);
 * countOnce(); // => 1, (count = 1)
 * countOnce(); // => 1, (count = 1)
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (fn) {
  return (function () {
    var first = arguments.length <= 0 || arguments[0] === undefined ? true : arguments[0];
    return function () {
      return first ? (first = !first, fn = fn()) : fn;
    };
  })();
};

module.exports = exports["default"];