/**
 * @module 1-liners/omit
 *
 * @description
 *
 * Creates a copy of the `object` without the given `props`.
 *
 * @example
 *
 * 	const omit = require('1-liners/omit');
 *
 * 	const object = {foo: 1, bar: 2, baz: 3};
 *
 * 	omit(['foo', 'baz'], object);  // => {bar: 2}
 *
 *
 */
"use strict";

exports.__esModule = true;
// istanbul ignore next

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

exports["default"] = function (props, obj) {
  return props.reduce(function (newObj, val) {
    return (function (_ref) {
      var dropped = _ref[val];

      var rest = _objectWithoutProperties(_ref, [val]);

      return rest;
    })(newObj);
  }, obj);
};

module.exports = exports["default"];