/**
 * @module 1-liners/isUndefined
 *
 * @description
 *
 * Returns `true` if a value or reference is `undefined`.
 *
 * @example
 *
 * 	const isUndefined = require('1-liners/isUndefined');
 *
 * 	isUndefined(undefined);        // => true
 *
 * 	isUndefined(null);             // => false
 * 	isUndefined(false);            // => false
 * 	isUndefined(NaN);              // => false
 * 	isUndefined('anything else');  // => false
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (value) {
  return value === void 0;
};

module.exports = exports["default"];