/**
 * @module 1-liners/isTypeOf
 *
 * @description
 *
 * Same as `typeof value === TYPE`.
 *
 * @example
 *
 * 	const isTypeOf = require('1-liners/isTypeOf');
 *
 * 	isTypeOf('boolean', false);            // => true
 * 	isTypeOf('boolean', true);             // => true
 *
 * 	isTypeOf('boolean', null);             // => false
 * 	isTypeOf('boolean', /anything else/);  // => false
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (type, value) {
  return typeof value === type;
};

module.exports = exports["default"];