/**
 * @module 1-liners/isObject
 *
 * @description
 *
 * Same as `value !== null && typeof value === 'object'`.
 *
 * @example
 *
 * 	const isObject = require('1-liners/isObject');
 *
 * 	isObject({});               // => true
 * 	isObject([]);               // => true
 * 	isObject(/anything/);       // => true
 *
 * 	isObject(null);             // => false
 * 	isObject('anything else');  // => false
 *
 */
'use strict';

exports.__esModule = true;

exports['default'] = function (value) {
  return value !== null && typeof value === 'object';
};

module.exports = exports['default'];