/**
 * @module 1-liners/isBoolean
 *
 * @description
 *
 * Same as `typeof value === 'boolean'`.
 *
 * @example
 *
 * 	const isBoolean = require('1-liners/isBoolean');
 *
 * 	isBoolean(false);            // => true
 * 	isBoolean(true);             // => true
 *
 * 	isBoolean(null);             // => false
 * 	isBoolean(/anything else/);  // => false
 *
 */
'use strict';

exports.__esModule = true;

exports['default'] = function (value) {
  return typeof value === 'boolean';
};

module.exports = exports['default'];