/**
 * @module 1-liners/ifThen
 *
 * @description
 *
 * Creates a function which calls `then` if the `predicate` is true
 * and returns `undefined` if the `predicate` is false.
 *
 * @example
 *
 * 	const ifThen = require('1-liners/ifThen');
 *
 * 	const words = ifThen((str) => typeof str === 'string', (str) => str.split(' '));
 *
 * 	words('Hello ES2015'); // => ['Hello', 'ES2015']
 *     words(['Hello', 'ES2015']); // => undefined
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (predicate, then) {
  return function () {
    return predicate.apply(undefined, arguments) ? then.apply(undefined, arguments) : undefined;
  };
};

module.exports = exports["default"];