/**
 * @module 1-liners/get
 *
 * @description
 *
 * Gets the value at path of object.
 *
 * @example
 *
 * 	const get = require('1-liners/get');
 *
 *  let obj = { a: { b: 42 } };
 *  get('a.b', obj); // => 42
 *
 */
'use strict';

exports.__esModule = true;

exports['default'] = function (path, obj) {
  return path.split('.').reduce(function (acc, current) {
    return acc && acc[current];
  }, obj);
};

module.exports = exports['default'];