/**
 * @module 1-liners/fold
 *
 * @description
 *
 * Same as [`array.reduce`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/array/reduce).
 *
 * @example
 *
 * 	const fold = require('1-liners/fold');
 *
 * 	fold(sum, 8, [1, 2, 3]); // => 2
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (fold, initial, arr) {
  return arr.reduce(fold, initial);
};

module.exports = exports["default"];