/**
 * @module 1-liners/endsWith
 *
 * @description
 *
 * Same as [`str.endsWith(searchString)`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith).
 *
 * @example
 *
 * 	const endsWith = require('1-liners/endsWith');
 *
 * 	endsWith('liners', '1-liners');  // => true
 * 	endsWith('stoeffel', 'nope');  // => false
 *
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (searchString, str) {
  return str.endsWith(searchString);
};

module.exports = exports["default"];