/**
 * @module 1-liners/composeAll
 * 
 * @description
 *
 * Compose a new function with a given array of functions.
 * 
 * @example
 * 
 * 	const composeAll = require('1-liners/composeAll');
 * 
 * 	composeAll([f, g, h])(1, 2) === f(g(h(1, 2)));
 * 
 */
"use strict";

exports.__esModule = true;

exports["default"] = function (fns) {
  return fns.reduce(function (f, g) {
    return function () {
      return f(g.apply(undefined, arguments));
    };
  });
};

module.exports = exports["default"];